/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.arbitrary.mimas;

import de.team33.patterns.arbitrary.mimas.Charger;
import de.team33.patterns.arbitrary.mimas.Methods;
import de.team33.patterns.arbitrary.mimas.Supplying;
import de.team33.patterns.arbitrary.mimas.Types;
import de.team33.patterns.arbitrary.mimas.UnfitConditionException;
import de.team33.patterns.arbitrary.mimas.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class Charging<S extends Charger, T>
extends Supplying<S> {
    private static final String METHOD_NOT_APPLICABLE = Util.load(Charging.class, "setterMethodNotApplicable.txt");
    private static final String NO_SUPPLIER = Util.load(Charging.class, "noSupplierMethodFound.txt");
    private static final Map<Class<?>, List<Method>> SETTERS = new ConcurrentHashMap(0);
    private final T target;
    private final Class<?> targetType;

    Charging(S source, T target, Collection<String> ignore) {
        super(source, ignore);
        this.target = target;
        this.targetType = target.getClass();
    }

    private static List<Method> newSettersOf(Class<?> targetType) {
        return Methods.publicSetters(targetType).collect(Collectors.toList());
    }

    private Stream<Method> desiredSetters() {
        return SETTERS.computeIfAbsent(this.targetType, Charging::newSettersOf).stream().filter(this.desired);
    }

    private Consumer<Object> setter(Method setter) {
        return value -> {
            try {
                setter.invoke(this.target, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new LocalException(String.format(METHOD_NOT_APPLICABLE, this.targetType, setter.toGenericString(), setter.getName()), e);
            }
        };
    }

    final T result() {
        this.desiredSetters().forEach(this::apply);
        return this.target;
    }

    private void apply(Method setter) {
        Type valueType = setter.getGenericParameterTypes()[0];
        Supplier<?> supplier = this.desiredSupplier(valueType, Charging.preference(setter));
        if (null == supplier) {
            throw new LocalException(this, setter, valueType);
        }
        this.setter(setter).accept(supplier.get());
    }

    private static BinaryOperator<Method> preference(Method setter) {
        return (left, right) -> Charging.preference(Methods.normalName(setter), left, right);
    }

    private static Method preference(String setterName, Method left, Method right) {
        return Methods.normalName(right).equals(setterName) ? right : left;
    }

    private static final class LocalException
    extends UnfitConditionException {
        LocalException(String message, Throwable cause) {
            super(message, cause);
        }

        LocalException(Charging<?, ?> charging, Method setter, Type valueType) {
            super(LocalException.missingMessage(charging, setter, valueType), null);
        }

        private static String missingMessage(Charging<?, ?> charging, Method setter, Type valueType) {
            Types.Naming naming = Types.naming(valueType);
            String name1 = naming.parameterizedName(valueType);
            String name2 = Methods.normalName(setter);
            return String.format(NO_SUPPLIER, charging.sourceType, charging.targetType, setter.toGenericString(), setter.getName(), name1, name2);
        }
    }
}

