/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.arbitrary.mimas;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class Types {
    private static final Map<Type, Collection<Type>> MATCHING = Types.newMatching();

    private Types() {
    }

    private static Map<Type, Collection<Type>> newMatching() {
        HashMap<Type, List<Type>> result = new HashMap<Type, List<Type>>(2 * Primary.values().length);
        for (Primary primary : Primary.values()) {
            result.put(primary.type, primary.matching);
            result.put(primary.boxed, primary.matching);
        }
        return Map.copyOf(result);
    }

    static Naming naming(Type type) {
        Class<?> typeClass = type.getClass();
        return Stream.of(Naming.values()).filter(value -> value.typeClass.isAssignableFrom(typeClass)).findAny().orElseThrow(() -> new NoSuchElementException(String.format("No entry found for type <%s>", typeClass)));
    }

    static Object defaultValue(Type type) {
        return Stream.of(Primary.values()).filter(primary -> type.equals(primary.type)).findAny().map(primary -> primary.value).orElse(null);
    }

    static boolean isMatching(Type desired, Type found) {
        return Optional.ofNullable(MATCHING.get(found)).orElseGet(() -> Collections.singleton(found)).contains(desired);
    }

    private static enum Primary {
        BOOLEAN(Boolean.TYPE, Boolean.class, false),
        BYTE(Byte.TYPE, Byte.class, (byte)0),
        SHORT(Short.TYPE, Short.class, (short)0),
        INT(Integer.TYPE, Integer.class, 0),
        LONG(Long.TYPE, Long.class, 0L),
        FLOAT(Float.TYPE, Float.class, Float.valueOf(0.0f)),
        DOUBLE(Double.TYPE, Double.class, 0.0),
        CHAR(Character.TYPE, Character.class, Character.valueOf('\u0000'));

        final Type type;
        final Type boxed;
        final List<Type> matching;
        final Object value;

        private <T> Primary(Class<T> type, Class<T> boxed, T value) {
            this.type = type;
            this.boxed = boxed;
            this.value = value;
            this.matching = List.of(type, boxed);
        }
    }

    static enum Naming {
        CLASS(Class.class, Class::getSimpleName, type -> ""),
        PARAMETERIZED(ParameterizedType.class, Naming::toSimpleName, Naming::toParameters),
        OTHER(Type.class, Type::getTypeName, type -> "");

        private final Class<?> typeClass;
        private final Function toSimpleName;
        private final Function toParameters;

        private <T extends Type> Naming(Class<T> typeClass, Function<T, String> toSimpleName, Function<T, String> toParameters) {
            this.typeClass = typeClass;
            this.toSimpleName = toSimpleName;
            this.toParameters = toParameters;
        }

        private static String toParameters(ParameterizedType type) {
            return Stream.of(type.getActualTypeArguments()).map(pType -> Types.naming(pType).simpleName((Type)pType)).collect(Collectors.joining(", ", "<", ">"));
        }

        private static String toSimpleName(ParameterizedType type) {
            Type rawType = type.getRawType();
            return Types.naming(rawType).simpleName(rawType);
        }

        final String simpleName(Type type) {
            return (String)this.toSimpleName.apply(type);
        }

        final String parameterizedName(Type type) {
            return this.simpleName(type) + this.toParameters.apply(type);
        }
    }
}

