/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.building.elara;

import java.util.function.Consumer;
import java.util.function.Function;

public class ProtoBuilder<C, B extends ProtoBuilder<C, B>> {
    private static final String ILLEGAL_BUILDER_CLASS = "<builderClass> is expected to represent <this> (%s) - but was %s";
    private final C container;

    protected ProtoBuilder(C container, Class<B> builderClass) {
        if (!builderClass.isAssignableFrom(this.getClass())) {
            throw new IllegalArgumentException(String.format(ILLEGAL_BUILDER_CLASS, this.getClass(), builderClass));
        }
        this.container = container;
    }

    protected final B setup(Consumer<C> consumer) {
        consumer.accept(this.container);
        return (B)this;
    }

    protected final <R> R build(Function<C, R> function) {
        return function.apply(this.container);
    }
}

