/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.building.elara;

import de.team33.patterns.building.elara.BuilderBase;
import de.team33.patterns.building.elara.Setup;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class LateBuilder<T, B extends LateBuilder<T, B>>
extends BuilderBase<B>
implements Setup<T, B> {
    private final List<Consumer<? super T>> setups = new LinkedList<Consumer<? super T>>();
    private final Supplier<? extends T> newResult;

    protected LateBuilder(Supplier<? extends T> newResult, Class<B> builderClass) {
        super(builderClass);
        this.newResult = newResult;
    }

    @Override
    public final B setup(Consumer<? super T> consumer) {
        this.setups.add(consumer);
        return (B)((LateBuilder)this.THIS());
    }

    public final T build() {
        return this.build(this.newResult.get());
    }

    private T build(T result) {
        for (Consumer<T> consumer : this.setups) {
            consumer.accept(result);
        }
        return result;
    }
}

