/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.building.elara;

import de.team33.patterns.building.anthe.SelfReferring;
import de.team33.patterns.building.elara.Setup;
import java.util.function.Consumer;
import java.util.function.Function;

public class ProtoBuilder<C, B extends ProtoBuilder<C, B>>
extends SelfReferring<B>
implements Setup<C, B> {
    private final C core;
    private final Lifecycle lifecycle;

    protected ProtoBuilder(C core, Class<B> builderClass) {
        this(core, Lifecycle.INFINITE, builderClass);
    }

    protected ProtoBuilder(C core, Lifecycle lifecycle, Class<B> builderClass) {
        super(builderClass);
        this.core = core;
        this.lifecycle = lifecycle;
    }

    @Override
    public final B setup(Consumer<? super C> consumer) {
        this.lifecycle.check();
        consumer.accept(this.core);
        return (B)((ProtoBuilder)this.THIS());
    }

    protected final <R> R build(Function<? super C, R> mapping) {
        this.lifecycle.increment();
        return mapping.apply(this.core);
    }

    public static interface Lifecycle {
        public static final Lifecycle INFINITE = new Lifecycle(){

            @Override
            public void check() {
            }

            @Override
            public void increment() {
            }
        };

        public void check();

        public void increment();
    }
}

