/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.enums.pan;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class Values<E extends Enum<E>> {
    private final Class<E> enumClass;

    private Values(Class<E> enumClass) {
        this.enumClass = enumClass;
    }

    public static <E extends Enum<E>> Values<E> of(Class<E> enumClass) {
        return new Values<E>(enumClass);
    }

    public final Stream<E> stream() {
        return Stream.of((Enum[])this.enumClass.getEnumConstants());
    }

    public final Stream<E> findAll(Predicate<? super E> filter) {
        return this.stream().filter(filter);
    }

    public final Optional<E> findAny(Predicate<? super E> filter) {
        return this.findAll(filter).findAny();
    }

    public final E findAny(Predicate<? super E> filter, E fallback) {
        return (E)((Enum)this.findAny(filter).orElse(fallback));
    }

    public final Optional<E> findFirst(Predicate<? super E> filter) {
        return this.findAll(filter).findFirst();
    }

    public final E findFirst(Predicate<? super E> filter, E fallback) {
        return (E)((Enum)this.findFirst(filter).orElse(fallback));
    }

    public final <T> Stream<T> mapAll(Function<? super E, ? extends T> mapping) {
        return this.stream().map(mapping);
    }

    public final <T> Stream<T> mapAll(Predicate<? super E> filter, Function<? super E, ? extends T> mapping) {
        return this.findAll(filter).map(mapping);
    }

    public final <R> Optional<R> mapAny(Predicate<? super E> filter, Function<? super E, ? extends R> mapping) {
        return this.findAny(filter).map(mapping);
    }

    public final <R> Optional<R> mapFirst(Predicate<? super E> filter, Function<? super E, ? extends R> mapping) {
        return this.findFirst(filter).map(mapping);
    }
}

