/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.exceptional.e1;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class WrappedException
extends RuntimeException {
    private static final String MISSING_EXCEPTION = "Missing: an exception to be wrapped in a " + WrappedException.class.getSimpleName();

    public WrappedException(String message, Throwable cause) {
        super(WrappedException.toMessage(message, cause), WrappedException.toCause(cause));
    }

    public WrappedException(Throwable cause) {
        super(WrappedException.toMessage(null, cause), WrappedException.toCause(cause));
    }

    private static String toMessage(String message, Throwable cause) {
        boolean messageIsMissing = null == message;
        boolean causeIsMissing = null == cause;
        List<String> result = Arrays.asList(messageIsMissing || causeIsMissing ? "Wrapped:" : null, causeIsMissing ? "nothing!?" : null, causeIsMissing && !messageIsMissing ? "Message:" : null, messageIsMissing && !causeIsMissing ? WrappedException.toMessage(cause) : null, message);
        return result.stream().filter(Objects::nonNull).collect(Collectors.joining(" "));
    }

    private static String toMessage(Throwable cause) {
        return Optional.ofNullable(cause.getMessage()).orElseGet(() -> cause.getClass().getCanonicalName());
    }

    private static Throwable toCause(Throwable cause) {
        return null != cause ? cause : new IllegalStateException(MISSING_EXCEPTION);
    }
}

