/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.exceptional.e1;

import java.util.function.Function;
import java.util.function.Predicate;

public final class Revision<T extends Throwable> {
    private final T subject;

    private Revision(T subject) {
        this.subject = subject;
    }

    public static <T extends Throwable> Revision<T> of(T subject) {
        return new Revision<T>(subject);
    }

    public final <X extends Throwable> Revision<T> throwIf(Predicate<? super T> condition, Function<? super T, X> mapping) throws X {
        return this.throwIf(condition, mapping, this);
    }

    public final <R, X extends Throwable> R throwIf(Predicate<? super T> condition, Function<? super T, X> mapping, R result) throws X {
        if (condition.test(this.subject)) {
            throw (Throwable)mapping.apply(this.subject);
        }
        return result;
    }

    public final <X extends Throwable> Revision<T> reThrow(Class<X> xClass) throws X {
        return this.reThrow(xClass, this);
    }

    public final <R, X extends Throwable> R reThrow(Class<X> xClass, R result) throws X {
        return this.throwIf(xClass::isInstance, xClass::cast, result);
    }

    public final <R> R close(Function<? super T, R> mapping) {
        return mapping.apply(this.subject);
    }

    public final T close() {
        return this.subject;
    }

    @Deprecated
    public final <R> R finish(Function<? super T, R> mapping) {
        return this.close(mapping);
    }

    @Deprecated
    public final T finish() {
        return this.close();
    }
}

