/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.exceptional.e1;

import de.team33.patterns.exceptional.e1.Revision;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class WrappedException
extends RuntimeException {
    private static final String MISSING_EXCEPTION = "Missing: an exception to be wrapped in a " + WrappedException.class.getSimpleName();
    private final Revision<?> revision;

    private WrappedException(Throwable cause, String message) {
        super(message, cause);
        this.revision = Revision.of(cause);
    }

    public WrappedException(String message, Throwable cause) {
        this(WrappedException.toCause(cause), WrappedException.toMessage(message, cause));
    }

    public WrappedException(Throwable cause) {
        this(WrappedException.toCause(cause), WrappedException.toMessage(null, cause));
    }

    private static String toMessage(String message, Throwable cause) {
        boolean messageIsMissing = null == message;
        boolean causeIsMissing = null == cause;
        List<String> result = Arrays.asList(messageIsMissing || causeIsMissing ? "Wrapped:" : null, causeIsMissing ? "nothing!?" : null, causeIsMissing && !messageIsMissing ? "Message:" : null, messageIsMissing && !causeIsMissing ? WrappedException.toMessage(cause) : null, message);
        return result.stream().filter(Objects::nonNull).collect(Collectors.joining(" "));
    }

    private static String toMessage(Throwable cause) {
        return Optional.ofNullable(cause.getMessage()).orElseGet(() -> cause.getClass().getCanonicalName());
    }

    private static Throwable toCause(Throwable cause) {
        return null != cause ? cause : new IllegalStateException(MISSING_EXCEPTION);
    }

    public final <X extends Throwable> WrappedException reThrowCauseIf(Predicate<? super Throwable> condition, Function<? super Throwable, X> mapping) throws X {
        return this.revision.throwIf(condition, mapping, this);
    }

    public final <X extends Throwable> WrappedException reThrowCauseAs(Class<X> xClass) throws X {
        return this.revision.reThrow(xClass, this);
    }
}

