/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.execution.metis;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleExecutorService
extends AbstractExecutorService {
    private static final Logger LOG = Logger.getLogger(SimpleExecutorService.class.getCanonicalName());
    private static final AtomicLong NEXT_INDEX = new AtomicLong(0L);
    private final String namePrefix = this.getClass().getCanonicalName() + "#" + NEXT_INDEX.getAndIncrement() + "#";
    private final AtomicLong nextIndex = new AtomicLong(0L);
    private final Condition condition = new Condition();

    @Override
    public final void shutdown() {
        this.condition.shutdown();
    }

    @Override
    public final List<Runnable> shutdownNow() {
        this.condition.shutdown();
        return Collections.emptyList();
    }

    @Override
    public final boolean isShutdown() {
        return this.condition.isShutdown();
    }

    @Override
    public final boolean isTerminated() {
        return this.condition.isTerminated();
    }

    @Override
    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.condition.awaitTermination(System.currentTimeMillis(), unit.toMillis(timeout));
        return this.condition.isTerminated();
    }

    @Override
    public final void execute(Runnable command) {
        if (this.condition.isNormal()) {
            String name = this.nextThreadName();
            new Thread(() -> this.run(command, name), name).start();
        } else {
            LOG.log(Level.WARNING, () -> "this executor service is terminated - command ignored: " + command);
        }
    }

    private String nextThreadName() {
        return this.namePrefix + this.nextIndex.getAndIncrement();
    }

    private void run(Runnable command, String name) {
        this.condition.increment();
        try {
            command.run();
            LOG.log(Level.FINE, () -> "Thread terminates normal: " + name);
        }
        catch (Error | RuntimeException e) {
            LOG.log(Level.WARNING, e, () -> "Thread terminates exceptional: " + name);
            throw e;
        }
        finally {
            this.condition.decrement();
        }
    }

    private static class Condition {
        private final AtomicLong counter = new AtomicLong(0L);
        private volatile State state = State.NORMAL;

        private Condition() {
        }

        final boolean isNormal() {
            return State.NORMAL == this.state;
        }

        final boolean isShutdown() {
            return State.SHUTDOWN == this.state;
        }

        final boolean isTerminated() {
            return this.isShutdown() && 0L == this.counter.get();
        }

        final synchronized void shutdown() {
            this.state = State.SHUTDOWN;
            this.notifyAll();
        }

        final synchronized void awaitTermination(long time0, long timeoutMillis) throws InterruptedException {
            long delta = 0L;
            while (delta < timeoutMillis && !this.isTerminated()) {
                this.wait(timeoutMillis - delta);
                delta = System.currentTimeMillis() - time0;
            }
        }

        final void increment() {
            this.counter.incrementAndGet();
        }

        final synchronized void decrement() {
            this.counter.decrementAndGet();
            this.notifyAll();
        }
    }

    private static enum State {
        NORMAL,
        SHUTDOWN;

    }
}

