/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.execution.metis;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleAsyncExecutor
implements Executor {
    private static final Logger LOG = Logger.getLogger(SimpleAsyncExecutor.class.getCanonicalName());
    private static final AtomicLong NEXT_INDEX = new AtomicLong(0L);
    private final String namePrefix = this.getClass().getCanonicalName() + "#" + NEXT_INDEX.getAndIncrement() + "#";
    private final AtomicLong anyIndex = new AtomicLong(0L);

    @Override
    public final void execute(Runnable command) {
        String name = this.anyName();
        new Thread(() -> SimpleAsyncExecutor.run(command, name), name).start();
    }

    private static void run(Runnable command, String name) {
        try {
            command.run();
            LOG.log(Level.FINE, () -> "Thread terminated normal: " + name);
        }
        catch (Error | RuntimeException e) {
            LOG.log(Level.WARNING, e, () -> "Thread terminated exceptional: " + name);
            throw e;
        }
    }

    private String anyName() {
        return this.namePrefix + this.anyIndex.getAndIncrement();
    }
}

