/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.hashing.pandia;

import de.team33.patterns.lazy.narvi.Lazy;
import java.math.BigInteger;
import java.util.Arrays;

public class Hash {
    private final byte[] bytes;
    private final transient Lazy<BigInteger> lazyBigInteger = Lazy.init(this::newBigInteger);

    Hash(byte[] bytes) {
        if (null == bytes || 0 >= bytes.length) {
            String found = null == bytes ? null : "empty";
            String message = "the given byte array is expected not to be empty - but was " + found;
            throw new IllegalArgumentException(message);
        }
        this.bytes = bytes;
    }

    private BigInteger newBigInteger() {
        return new BigInteger(1, this.bytes);
    }

    public final byte[] bytes() {
        return (byte[])this.bytes.clone();
    }

    public final BigInteger toBigInteger() {
        return (BigInteger)this.lazyBigInteger.get();
    }

    public final String toHexString() {
        return this.toString("0123456789abcdef");
    }

    public final String toString(String chars) {
        BigInteger base = BigInteger.valueOf(chars.length());
        StringBuilder result = new StringBuilder(0);
        BigInteger tail = this.toBigInteger();
        while (BigInteger.ZERO.compareTo(tail) != 0) {
            int digit = tail.mod(base).intValue();
            result.insert(0, chars.charAt(digit));
            tail = tail.divide(base);
        }
        return result.isEmpty() ? chars.substring(0, 1) : result.toString();
    }

    public final String toString() {
        return Arrays.toString(this.bytes);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Hash)) return false;
        Hash other = (Hash)obj;
        if (!Arrays.equals(this.bytes, other.bytes)) return false;
        return true;
    }
}

