/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.hashing.pandia;

import de.team33.patterns.exceptional.dione.XSupplier;
import de.team33.patterns.hashing.pandia.Hash;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public enum Algorithm {
    MD5("MD5"),
    SHA_1("SHA-1"),
    SHA_256("SHA-256"),
    SHA_512("SHA-512");

    private static final int ONE_KB = 1024;
    private final String ident;

    private Algorithm(String ident) {
        this.ident = ident;
    }

    public final String ident() {
        return this.ident;
    }

    public final Hash hash(String origin) {
        return this.hash(origin, StandardCharsets.UTF_8);
    }

    public final Hash hash(String origin, Charset charset) {
        return this.hash(origin.getBytes(charset));
    }

    public final Hash hash(byte[] bytes) {
        return this.hash((XSupplier<? extends InputStream, ? extends IOException>)((XSupplier)() -> new ByteArrayInputStream(bytes)));
    }

    public final Hash hash(Path path) {
        return this.hash((XSupplier<? extends InputStream, ? extends IOException>)((XSupplier)() -> Files.newInputStream(path, new OpenOption[0])));
    }

    public final Hash hash(XSupplier<? extends InputStream, ? extends IOException> streamable) {
        Hash hash;
        block8: {
            InputStream in = (InputStream)streamable.get();
            try {
                hash = this.hash(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
            in.close();
        }
        return hash;
    }

    public final Hash hash(InputStream in) throws IOException {
        MessageDigest md = this.getMessageDigest();
        byte[] buffer = new byte[1024];
        int read = in.read(buffer, 0, 1024);
        while (0 < read) {
            md.update(buffer, 0, read);
            read = in.read(buffer, 0, 1024);
        }
        return new Hash(md.digest());
    }

    private MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(this.ident);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Message digest algorithm <" + this.ident + "> is not supported", e);
        }
    }
}

