/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.io.deimos;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Collectors;

public final class TextIO {
    private static final String CANNOT_READ_RESOURCE = "cannot read resource%n    resource name   : %s%n    referring class : %s%n";
    private static final String CANNOT_READ_FILE = "cannot read file%n    path : %s%n";
    private static final String NEW_LINE = String.format("%n", new Object[0]);

    private TextIO() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(Class<?> refClass, String rsrcName) {
        try (InputStream in = refClass.getResourceAsStream(rsrcName);){
            String string = TextIO.read(in);
            return string;
        }
        catch (IOException | NullPointerException e) {
            throw new IllegalArgumentException(String.format(CANNOT_READ_RESOURCE, rsrcName, refClass), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(Path path) {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            String string = TextIO.read(in);
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format(CANNOT_READ_FILE, path), e);
        }
    }

    public static String read(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining(NEW_LINE));
            return string;
        }
    }
}

