/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.io.deimos;

import de.team33.patterns.exceptional.dione.XFunction;
import de.team33.patterns.exceptional.dione.XSupplier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Resource {
    private static final String CANNOT_READ_RESOURCE = "cannot read resource%n    resource name   : %s%n    referring class : %s%n    cause type      : %s%n    cause message   : %s%n";
    private static final String CANNOT_READ_FILE = "cannot read file%n    path          : %s%n    cause type    : %s%n    cause message : %s%n";
    private static final String NEW_LINE = String.format("%n", new Object[0]);
    private final Charset charset;
    private final XSupplier<InputStream, IOException> newInputStream;
    private final Function<Exception, String> newExceptionMessage;

    protected Resource(Charset charset, XSupplier<InputStream, IOException> newInputStream, Function<Exception, String> newExceptionMessage) {
        this.charset = charset;
        this.newInputStream = newInputStream;
        this.newExceptionMessage = newExceptionMessage;
    }

    public static Resource by(Class<?> referringClass, String resourceName) {
        return new Resource(StandardCharsets.UTF_8, (XSupplier<InputStream, IOException>)((XSupplier)() -> referringClass.getResourceAsStream(resourceName)), caught -> String.format(CANNOT_READ_RESOURCE, resourceName, referringClass, caught.getClass().getCanonicalName(), caught.getMessage()));
    }

    public static Resource by(Path path) {
        return new Resource(StandardCharsets.UTF_8, (XSupplier<InputStream, IOException>)((XSupplier)() -> Files.newInputStream(path, new OpenOption[0])), caught -> String.format(CANNOT_READ_FILE, path, caught.getClass().getCanonicalName(), caught.getMessage()));
    }

    public final Resource using(Charset charset) {
        return new Resource(charset, this.newInputStream, this.newExceptionMessage);
    }

    private static String readText(BufferedReader reader) {
        return reader.lines().collect(Collectors.joining(NEW_LINE));
    }

    private static Properties readProperties(Reader in) throws IOException {
        Properties result = new Properties();
        result.load(in);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <R> R readByteStream(XFunction<InputStream, R, IOException> function) {
        try (InputStream in = (InputStream)this.newInputStream.get();){
            Object object = function.apply((Object)in);
            return (R)object;
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalArgumentException(this.newExceptionMessage.apply(e), e);
        }
    }

    /*
     * Exception decompiling
     */
    private <R> R readCharStream(InputStream stream, XFunction<BufferedReader, R, IOException> function) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final <R> R readCharStream(XFunction<BufferedReader, R, IOException> function) {
        return this.readByteStream(in -> this.readCharStream((InputStream)in, function));
    }

    public final String readText() {
        return (String)this.readCharStream(Resource::readText);
    }

    public final Properties readProperties() {
        return (Properties)this.readCharStream(Resource::readProperties);
    }
}

