/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.lazy.e1;

import de.team33.patterns.exceptional.e1.XSupplier;

class LazyBase<T, X extends Exception> {
    volatile XSupplier<T, X> backing;

    LazyBase(XSupplier<T, X> initial) {
        this.backing = this.initiation(initial);
    }

    private XSupplier<T, X> initiation(final XSupplier<T, X> initial) {
        return new XSupplier<T, X>(){
            private final Object monitor = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T get() throws Exception {
                Object object = this.monitor;
                synchronized (object) {
                    if (LazyBase.this.backing == this) {
                        Object result = initial.get();
                        LazyBase.this.backing = () -> result;
                    }
                }
                return LazyBase.this.backing.get();
            }
        };
    }
}

