/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.lazy.narvi;

import de.team33.patterns.exceptional.e1.Converter;
import de.team33.patterns.exceptional.e1.XSupplier;
import java.util.function.Supplier;

public class Lazy<T> {
    private static final Converter CNV = Converter.using(x$0 -> new InitException((Throwable)x$0));
    private volatile Supplier<T> backing;

    private Lazy(Supplier<? extends T> initial) {
        this.backing = new Initial(initial);
    }

    public static <T> Lazy<T> init(Supplier<? extends T> initial) {
        return new Lazy<T>(initial);
    }

    public static <T> Lazy<T> initEx(XSupplier<? extends T, ?> initial) {
        return Lazy.init(CNV.supplier(initial));
    }

    public final T get() {
        return this.backing.get();
    }

    public static class InitException
    extends RuntimeException {
        private InitException(Throwable cause) {
            super(cause.getMessage(), cause);
        }
    }

    private class Initial
    implements Supplier<T> {
        private final Supplier<? extends T> initial;

        private Initial(Supplier<? extends T> initial) {
            this.initial = initial;
        }

        @Override
        public final synchronized T get() {
            if (Lazy.this.backing == this) {
                Object result = this.initial.get();
                Lazy.this.backing = () -> result;
            }
            return Lazy.this.backing.get();
        }
    }
}

