/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.lazy.narvi;

import de.team33.patterns.lazy.narvi.Lazy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class LazyFeatures<H> {
    private final Map<Key, Lazy> backing = new ConcurrentHashMap<Key, Lazy>(0);

    protected abstract H host();

    public final <R> R get(Key<H, R> key) {
        Lazy lazy = this.backing.computeIfAbsent(key, this::newLazy);
        return (R)lazy.get();
    }

    private <R> Lazy<R> newLazy(Key<? super H, ? extends R> key) {
        return Lazy.init(() -> key.init((H)this.host()));
    }

    public final void reset(Key<?, ?> key) {
        this.backing.remove(key);
    }

    public final void reset() {
        this.backing.clear();
    }

    @FunctionalInterface
    public static interface Key<H, R> {
        public R init(H var1);
    }
}

