/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.lazy.narvi;

import de.team33.patterns.exceptional.dione.XSupplier;

class Mutual<T, X extends Exception> {
    private volatile XSupplier<T, X> backing;

    Mutual(XSupplier<? extends T, ? extends X> initial) {
        this.backing = new Provident(initial);
    }

    private static <T, X extends Exception> XSupplier<T, X> definite(T value) {
        return () -> value;
    }

    T get() throws X {
        return (T)this.backing.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean isProvident(XSupplier<?, ?> initial) {
        XSupplier<T, X> xSupplier = this.backing;
        if (!(xSupplier instanceof Provident)) return false;
        Provident provident = (Provident)xSupplier;
        if (initial != provident.initial) return false;
        return true;
    }

    final void reset(XSupplier<? extends T, ? extends X> initial) {
        this.backing = new Provident(initial);
    }

    private final class Provident
    implements XSupplier<T, X> {
        private final XSupplier<? extends T, ? extends X> initial;

        private Provident(XSupplier<? extends T, ? extends X> initial) {
            this.initial = initial;
        }

        public synchronized T get() throws Exception {
            if (Mutual.this.backing == this) {
                Mutual.this.backing = Mutual.definite(this.initial.get());
            }
            return Mutual.this.backing.get();
        }
    }
}

