/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.notes.eris;

import de.team33.patterns.notes.eris.Channel;
import de.team33.patterns.notes.eris.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class Audience
implements Registry {
    private final Object monitor = new Object();
    private final Map<Channel<?>, List<Consumer<?>>> backing = new HashMap(0);
    private final Executor executor;

    public Audience() {
        this(Runnable::run);
    }

    public Audience(Executor executor) {
        this.executor = executor;
    }

    private <M> List<Consumer<? super M>> getListeners(Channel<M> channel) {
        List<Consumer<?>> list = this.backing.get(channel);
        return null == list ? Collections.emptyList() : list;
    }

    private void putListeners(Channel channel, List newList) {
        this.backing.put(channel, newList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <M> void add(Channel<M> channel, Consumer<? super M> listener) {
        Object object = this.monitor;
        synchronized (object) {
            List<Consumer<M>> oldList = this.getListeners(channel);
            ArrayList<Consumer<? super M>> newList = new ArrayList<Consumer<? super M>>(oldList.size() + 1);
            newList.addAll(oldList);
            newList.add(listener);
            this.putListeners(channel, newList);
        }
    }

    private static <M> Optional<Consumer<M>> emitter(Collection<? extends Consumer<? super M>> listeners) {
        return listeners.isEmpty() ? Optional.empty() : Optional.of(message -> listeners.forEach(listener -> listener.accept(message)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <M> Optional<Consumer<M>> emitter(Channel<? super M> channel) {
        Object object = this.monitor;
        synchronized (object) {
            return Audience.emitter(this.getListeners(channel));
        }
    }

    public final <M> void send(Channel<M> channel, M message) {
        this.emitter(channel).ifPresent(emitter -> this.executor.execute(() -> emitter.accept(message)));
    }
}

