/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.notes.eris;

import de.team33.patterns.notes.eris.Audience;
import de.team33.patterns.notes.eris.Registry;
import java.util.function.Function;

public class ProtoService<S extends ProtoService<S>> {
    private static final String ILLEGAL_BUILDER_CLASS = "<builderClass> is expected to represent the class of <this> (%s) - but was %s";
    private final Audience audience;

    protected ProtoService(Audience audience, Class<S> serviceClass) {
        if (!serviceClass.isAssignableFrom(this.getClass())) {
            throw new IllegalArgumentException(String.format(ILLEGAL_BUILDER_CLASS, this.getClass(), serviceClass));
        }
        this.audience = audience;
    }

    public final Registry registry() {
        return this.audience;
    }

    @SafeVarargs
    protected final void fire(Channel<S, ?> ... channels) {
        for (Channel<S, ?> channel : channels) {
            this.audience.send(channel, channel.apply(this));
        }
    }

    @FunctionalInterface
    public static interface Channel<S, M>
    extends de.team33.patterns.notes.eris.Channel<M>,
    Function<S, M> {
    }
}

