/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.pooling.e1;

import de.team33.patterns.exceptional.e1.XConsumer;
import de.team33.patterns.exceptional.e1.XFunction;
import de.team33.patterns.exceptional.e1.XSupplier;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Function;

public class XProvider<S, X extends Exception> {
    private static final Void IRRELEVANT = null;
    private final Queue<S> stock = new ConcurrentLinkedQueue<S>();
    private final XSupplier<S, X> newItem;

    public XProvider(XSupplier<S, X> newItem) {
        this.newItem = newItem;
    }

    public final <EX extends Exception> void runEx(XConsumer<? super S, EX> consumer) throws X, EX {
        this.getEx(parameter -> {
            consumer.accept(parameter);
            return IRRELEVANT;
        });
    }

    public final void run(Consumer<? super S> consumer) throws X {
        this.runEx(consumer::accept);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R, EX extends Exception> R getEx(XFunction<? super S, R, EX> function) throws X, EX {
        S stocked = this.stock.poll();
        S item = null == stocked ? this.newItem.get() : stocked;
        try {
            Object object = function.apply(item);
            return (R)object;
        }
        finally {
            this.stock.add(item);
        }
    }

    public final <R> R get(Function<? super S, R> function) throws X {
        return this.getEx(function::apply);
    }
}

