/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.pooling.e1;

import de.team33.patterns.exceptional.e1.XConsumer;
import de.team33.patterns.exceptional.e1.XFunction;
import de.team33.patterns.exceptional.e1.XSupplier;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class Mutual<S, E extends Exception> {
    private static final Void VOID = null;
    private final Queue<S> stock = new ConcurrentLinkedQueue<S>();
    private final XSupplier<S, E> newItem;

    Mutual(XSupplier<S, E> newItem) {
        this.newItem = newItem;
    }

    final <X extends Exception> void accept(XConsumer<? super S, X> xConsumer) throws E, X {
        this.apply(subject -> {
            xConsumer.accept(subject);
            return VOID;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <R, X extends Exception> R apply(XFunction<? super S, R, X> function) throws E, X {
        S stocked = this.stock.poll();
        S item = null == stocked ? this.newItem.get() : stocked;
        try {
            Object object = function.apply(item);
            return (R)object;
        }
        finally {
            this.stock.add(item);
        }
    }

    public final int size() {
        return this.stock.size();
    }
}

