/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.properties.e1;

import de.team33.patterns.properties.e1.MappingUtil;
import de.team33.patterns.properties.e1.TargetOperation;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;

@FunctionalInterface
public interface Mapping<T> {
    public static <T> Builder<T> add(String name, Function<T, Object> getter) {
        return new Builder<T>().add(name, getter);
    }

    public TargetOperation<Map<String, Object>> map(T var1);

    default public Map<String, Object> toMap(T origin) {
        return this.map(origin).to(new TreeMap());
    }

    public static class Builder<T> {
        private final Map<String, Function<T, ?>> getters = new TreeMap();

        private static <T> Mapping<T> newMapping(Map<String, ? extends Function<T, ?>> getters) {
            return origin -> MappingUtil.mappingOperation(getters, origin);
        }

        public final Builder<T> add(String name, Function<T, ?> getter) {
            this.getters.put(name, getter);
            return this;
        }

        public final Mapping<T> build() {
            return Builder.newMapping(Collections.unmodifiableMap(new TreeMap(this.getters)));
        }
    }
}

