/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.properties.e1;

import de.team33.patterns.exceptional.e1.Converter;
import de.team33.patterns.properties.e1.AccMapping;
import de.team33.patterns.properties.e1.Accessor;
import de.team33.patterns.properties.e1.BiMapping;
import de.team33.patterns.properties.e1.Mapping;
import de.team33.patterns.properties.e1.MappingUtil;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Methods {
    private Methods() {
    }

    public static <T> Mapping<T> mapping(Class<T> tClass) {
        Collector<Entry, ?, Map<String, Function>> collector = Collectors.toMap(Entry::normalName, entry -> Mutual.CONVERTER.function(x$0 -> entry.method.invoke(x$0, new Object[0])));
        Map<String, Function> getters = Stream.of(tClass.getMethods()).filter(Mutual::isSignificant).filter(Mutual::isNoParameter).map(Entry::new).filter(entry -> entry.prefix.isGetter()).collect(collector);
        return origin -> MappingUtil.mappingOperation(getters, origin);
    }

    public static <T> BiMapping<T> biMapping(Class<T> tClass) {
        Supplier<BiSelector> newSelector = () -> new BiSelector();
        Map methods = Stream.of(tClass.getMethods()).filter(Mutual::isSignificant).map(Entry::new).collect(newSelector, BiSelector::add, BiSelector::addAll).toMethods();
        return new AccMapping(methods);
    }

    private static class Entry {
        final Prefix prefix;
        final Method method;

        Entry(Method method) {
            this.prefix = Stream.of(Prefix.values()).filter(Entry.isPrefix(method)).findAny().orElse(Prefix.NONE);
            this.method = method;
        }

        static Predicate<Prefix> isPrefix(Method method) {
            return prefix -> method.getName().startsWith(prefix.name());
        }

        final String normalName() {
            int index0;
            String methodName = this.method.getName();
            int index1 = index0 + ((index0 = this.prefix.length) < methodName.length() ? 1 : 0);
            return methodName.substring(index0, index1).toLowerCase(Locale.ROOT) + methodName.substring(index1);
        }

        public final String toString() {
            return this.method.toString();
        }
    }

    private static class BiSelector<T> {
        private final List<Entry> getters = new LinkedList<Entry>();
        private final Map<String, List<Entry>> setters = new TreeMap<String, List<Entry>>();

        private BiSelector() {
        }

        private static Method setter(Class<?> paramType, List<? extends Entry> setters) {
            return setters.stream().map(setter -> setter.method).filter(setter -> setter.getParameterTypes()[0].isAssignableFrom(paramType)).findAny().orElseThrow(() -> new IllegalStateException(String.format("No setter found matching parameter type %s in %s", paramType, setters)));
        }

        final void add(Entry entry) {
            if (entry.prefix.isGetter() && Mutual.isParameterCount(entry.method, 0)) {
                this.getters.add(entry);
            }
            if (entry.prefix.isSetter() && Mutual.isParameterCount(entry.method, 1)) {
                this.setters.computeIfAbsent(entry.normalName(), name -> new LinkedList()).add(entry);
            }
        }

        final void addAll(BiSelector<T> other) {
            throw new UnsupportedOperationException("Unexpectedly called");
        }

        final Map<String, Accessor<T, Object>> toMethods() {
            return this.getters.stream().collect(Collectors.toMap(Entry::normalName, this::toAccessor));
        }

        private Accessor<T, Object> toAccessor(Entry getterEntry) {
            Method getter = getterEntry.method;
            String name = getterEntry.normalName();
            Method setter = BiSelector.setter(getter.getReturnType(), this.setters.get(name));
            return this.toAccessor(getter, setter);
        }

        private Accessor<T, Object> toAccessor(Method getter, Method setter) {
            return Accessor.combine(Mutual.CONVERTER.function(x$0 -> getter.invoke(x$0, new Object[0])), Mutual.CONVERTER.biConsumer((x$0, xva$1) -> setter.invoke(x$0, xva$1)));
        }
    }

    private static final class Mutual {
        static final int SYNTHETIC = 4096;
        static final int NOT_SIGNIFICANT = 4360;
        static final Converter CONVERTER = Converter.using(cause -> new IllegalArgumentException(cause.getMessage(), (Throwable)cause));

        private Mutual() {
        }

        static boolean isNoParameter(Method method) {
            return Mutual.isParameterCount(method, 0);
        }

        static boolean isParameterCount(Method method, int count) {
            return method.getParameterCount() == count;
        }

        static boolean isSignificant(Method method) {
            return Mutual.isSignificant(method.getModifiers());
        }

        static boolean isSignificant(int modifiers) {
            return 0 == (modifiers & 0x1108);
        }
    }

    private static enum Prefix {
        get(true),
        is(true),
        set(true),
        NONE(false);

        private static final Set<Prefix> GETTERS;
        private static final Set<Prefix> SETTERS;
        final int length;

        private Prefix(boolean real) {
            this.length = real ? this.name().length() : 0;
        }

        final boolean isGetter() {
            return GETTERS.contains((Object)this);
        }

        final boolean isSetter() {
            return SETTERS.contains((Object)this);
        }

        static {
            GETTERS = Collections.unmodifiableSet(EnumSet.of(get, is));
            SETTERS = Collections.unmodifiableSet(EnumSet.of(set));
        }
    }
}

