/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.proving.kerberos;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Guard {
    private static final String DEFAULT_MESSAGE = "prove failed";
    private static final Function<Object, String> DEFAULT_TO_MESSAGE = candidate -> "%s: <candidate> is <%s>".formatted(DEFAULT_MESSAGE, candidate);

    private Guard() {
    }

    public static void prove(boolean condition) {
        Guard.prove(condition, () -> DEFAULT_MESSAGE);
    }

    public static void prove(boolean condition, Supplier<String> toMessage) {
        Guard.prove(condition, toMessage, IllegalStateException::new);
    }

    public static <E extends Exception> void prove(boolean condition, Supplier<String> toMessage, Function<? super String, E> toException) throws E {
        if (!condition) {
            throw (Exception)toException.apply(toMessage.get());
        }
    }

    public static <T> T proved(T candidate, Predicate<? super T> condition) {
        return (T)Guard.proved(candidate, condition, DEFAULT_TO_MESSAGE);
    }

    public static <T> T proved(T candidate, Predicate<? super T> condition, Function<? super T, String> toMessage) {
        return Guard.proved(candidate, condition, toMessage, IllegalArgumentException::new);
    }

    public static <T, E extends Exception> T proved(T candidate, Predicate<? super T> condition, Function<? super T, String> toMessage, Function<? super String, E> toException) throws E {
        Guard.prove(condition.test(candidate), () -> (String)toMessage.apply((Object)candidate), toException);
        return candidate;
    }

    public static <T> T nonNull(T candidate) {
        return (T)Guard.nonNull(candidate, DEFAULT_TO_MESSAGE);
    }

    public static <T> T nonNull(T candidate, Function<? super T, String> toMessage) {
        return Guard.proved(candidate, Objects::nonNull, toMessage, NullPointerException::new);
    }
}

