/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.serial.charon;

import de.team33.patterns.serial.charon.Streamable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class Series<E> {
    public static <E> Series<E> empty() {
        return Empty.INSTANCE;
    }

    @SafeVarargs
    public static <E> Series<E> of(E ... elements) {
        return Series.of(Arrays.asList(elements));
    }

    public static <E> Series<E> of(Streamable<? extends E> origin) {
        return Series.of(origin.stream().collect(Collectors.toList()));
    }

    public static <E> Series<E> of(Iterable<? extends E> origin) {
        if (origin instanceof Collection) {
            return Series.of((Collection)origin);
        }
        Streamable streamable = () -> StreamSupport.stream(origin.spliterator(), false);
        return Series.of(streamable);
    }

    public static <E> Series<E> of(Collection<? extends E> origin) {
        return Series.seriesOf(new ArrayList<E>(origin), 0);
    }

    private static <E> Series<E> seriesOf(List<E> backing, int headIndex) {
        assert (0 <= headIndex);
        return headIndex < backing.size() ? new Charged(backing, headIndex) : Series.empty();
    }

    public final boolean isEmpty() {
        return 0 == this.size();
    }

    public final boolean isCharged() {
        return 0 < this.size();
    }

    public final <R> Optional<R> ifCharged(BiFunction<E, Series<E>, R> function) {
        return Optional.of(this).filter(Series::isCharged).map(series -> function.apply(series.head(), series.tail()));
    }

    public abstract E head();

    public abstract Series<E> tail();

    public abstract int size();

    public abstract List<E> asList();

    public final Stream<E> stream() {
        return this.asList().stream();
    }

    public final boolean equals(Object obj) {
        return this == obj || obj instanceof Series && this.asList().equals(((Series)obj).asList());
    }

    public final int hashCode() {
        return this.asList().hashCode();
    }

    public final String toString() {
        return this.asList().toString();
    }

    private static final class Charged<E>
    extends Series<E> {
        private final List<E> backing;
        private final int headIndex;

        private Charged(List<E> backing, int headIndex) {
            this.headIndex = headIndex;
            this.backing = backing;
        }

        @Override
        public final E head() {
            return this.backing.get(this.headIndex);
        }

        @Override
        public final Series<E> tail() {
            return Series.seriesOf(this.backing, this.headIndex + 1);
        }

        @Override
        public final int size() {
            return this.backing.size() - this.headIndex;
        }

        @Override
        public final List<E> asList() {
            return this.backing.subList(this.headIndex, this.backing.size());
        }
    }

    private static final class Empty<E>
    extends Series<E> {
        private static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        public final E head() {
            throw new NoSuchElementException("this Series is empty");
        }

        @Override
        public final Series<E> tail() {
            return Empty.empty();
        }

        @Override
        public final int size() {
            return 0;
        }

        @Override
        public final List<E> asList() {
            return Collections.emptyList();
        }
    }
}

