/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.testing.e1;

import de.team33.patterns.exceptional.e1.XConsumer;
import de.team33.patterns.exceptional.e1.XFunction;
import de.team33.patterns.testing.e1.Report;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class Parallel<R> {
    private final List<Thread> threads;
    private final Report.Builder<R> report = new Report.Builder();
    private final AtomicInteger executionCounter = new AtomicInteger(0);
    private final int numberOfExecutions;
    private long time0;

    private Parallel(int numberOfExecutions, int numberOfThreads, XFunction<Integer, R, ?> method) {
        this.numberOfExecutions = numberOfExecutions;
        this.threads = IntStream.range(0, numberOfThreads).mapToObj(threadIndex -> this.newThread(threadIndex, method)).collect(Collectors.toList());
    }

    public static <R> Report<R> apply(int numberOfExecutions, int numberOfThreads, XFunction<Integer, R, ?> operation) throws InterruptedException {
        return super.report();
    }

    public static <R> Report<R> apply(int numberOfExecutionsInSeparateThreads, XFunction<Integer, R, ?> operation) throws InterruptedException {
        return Parallel.apply(numberOfExecutionsInSeparateThreads, numberOfExecutionsInSeparateThreads, operation);
    }

    public static Report<Void> invoke(int numberOfExecutions, int numberOfThreads, XConsumer<Integer, ?> operation) throws InterruptedException {
        return Parallel.apply(numberOfExecutions, numberOfThreads, Parallel.toXFunction(operation));
    }

    public static Report<Void> invoke(int numberOfExecutionsInSeparateThreads, XConsumer<Integer, ?> operation) throws InterruptedException {
        return Parallel.apply(numberOfExecutionsInSeparateThreads, Parallel.toXFunction(operation));
    }

    private static <X extends Exception> XFunction<Integer, Void, X> toXFunction(XConsumer<Integer, X> operation) {
        return index -> {
            operation.accept(index);
            return null;
        };
    }

    private Thread newThread(int threadIndex, XFunction<Integer, R, ?> method) {
        return new Thread(this.newRunnable(method), this + ":" + threadIndex);
    }

    private Runnable newRunnable(XFunction<Integer, R, ?> method) {
        return () -> {
            int executionIndex = this.executionCounter.getAndIncrement();
            while (executionIndex < this.numberOfExecutions) {
                try {
                    this.report.add(method.apply((Object)executionIndex));
                }
                catch (Throwable e) {
                    this.report.add(e);
                }
                executionIndex = this.executionCounter.getAndIncrement();
            }
        };
    }

    private Parallel<R> startThreads() {
        this.time0 = System.currentTimeMillis();
        for (Thread thread : this.threads) {
            thread.start();
        }
        return this;
    }

    private Parallel<R> joinThreads() throws InterruptedException {
        for (Thread thread : this.threads) {
            thread.join();
        }
        this.report.setDuration(System.currentTimeMillis() - this.time0);
        return this;
    }

    private Report<R> report() {
        return this.report.build();
    }
}

