/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.testing.e1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Report<R> {
    private final List<R> results;
    private final List<Throwable> throwables;
    private final long duration;

    Report(Builder<R> builder) {
        this.results = Collections.unmodifiableList(new ArrayList(builder.results));
        this.throwables = Collections.unmodifiableList(new ArrayList<Throwable>(builder.throwables));
        this.duration = builder.duration;
    }

    public final List<R> getResults() {
        return this.results;
    }

    public final List<Throwable> getThrowables() {
        return this.throwables;
    }

    @SafeVarargs
    public final <X extends Throwable> List<X> getThrowables(Class<X> xClass, Class<? extends X> ... ignorable) {
        return this.streamThrowables(xClass, ignorable).collect(Collectors.toList());
    }

    @SafeVarargs
    public final <X extends Throwable> Stream<X> streamThrowables(Class<X> xClass, Class<? extends X> ... ignorable) {
        return this.throwables.stream().filter(xClass::isInstance).map(xClass::cast).filter(throwable -> Stream.of(ignorable).noneMatch(iClass -> iClass.isInstance(throwable)));
    }

    @SafeVarargs
    public final <X extends Throwable> Report<R> reThrow(Class<X> xClass, Class<? extends X> ... ignorable) throws X {
        Optional<X> caught = this.streamThrowables(xClass, ignorable).reduce((head, tail) -> {
            head.addSuppressed((Throwable)tail);
            return head;
        });
        if (caught.isPresent()) {
            throw (Throwable)caught.get();
        }
        return this;
    }

    public final Report<R> reThrowAny() throws Exception {
        return this.reThrow(Error.class, new Class[0]).reThrow(Exception.class, new Class[0]);
    }

    public final long getDuration() {
        return this.duration;
    }

    static class Builder<R> {
        final List<Throwable> throwables = Collections.synchronizedList(new LinkedList());
        final List<R> results = Collections.synchronizedList(new LinkedList());
        long duration;

        Builder() {
        }

        final Report<R> build() {
            return new Report(this);
        }

        final Builder<R> add(Throwable caught) {
            this.throwables.add(caught);
            return this;
        }

        final Builder<R> add(R result) {
            this.results.add(result);
            return this;
        }

        final Builder<R> setDuration(long duration) {
            this.duration = duration;
            return this;
        }
    }
}

