/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.testing.titan.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileInfo {
    private static final Comparator<Path> ORDER = Comparator.comparing(path -> path.getFileName().toString());
    private final String name;
    private final Type type;
    private final long size;
    private final Instant lastModified;
    private final List<FileInfo> content;

    private FileInfo(Path path, LinkOption[] options) {
        BasicFileAttributes attributes = FileInfo.basicFileAttributes(path, options);
        this.type = Type.of(attributes);
        this.name = path.getFileName().toString();
        this.size = null != attributes ? attributes.size() : 0L;
        this.lastModified = null != attributes ? attributes.lastModifiedTime().toInstant() : null;
        this.content = null != attributes && attributes.isDirectory() ? this.contentOf(path, options) : Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<FileInfo> contentOf(Path path, LinkOption[] options) {
        try (Stream<Path> stream = Files.list(path);){
            List<FileInfo> list = stream.sorted(ORDER).map(item -> new FileInfo((Path)item, options)).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    private static BasicFileAttributes basicFileAttributes(Path path, LinkOption[] options) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, options);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static FileInfo of(Path path, LinkOption ... options) {
        return new FileInfo(path, options);
    }

    private static String noDetail(Long size, Instant lastModified) {
        return "";
    }

    private static String regularDetail(Long size, Instant lastModified) {
        return String.format(" (%,d, %s)", size, lastModified);
    }

    private static String noTail(Integer indent, List<FileInfo> content) {
        return "";
    }

    private static String dirTail(Integer indent, List<FileInfo> content) {
        if (content.isEmpty()) {
            return " {}";
        }
        return String.format(" {%s%s}", FileInfo.dirTailBody(content, indent + 1), FileInfo.newLine(indent));
    }

    private static String dirTailBody(List<FileInfo> content, int indent) {
        String newLine = FileInfo.newLine(indent);
        return content.stream().map(fi -> fi.toString(indent)).collect(Collectors.joining(newLine, newLine, ""));
    }

    private static String newLine(int indent) {
        return String.format("%n%s", Stream.generate(() -> "    ").limit(indent).collect(Collectors.joining()));
    }

    public final String toString() {
        return this.toString(0);
    }

    public final String toString(int indent) {
        return String.format("%s : %s%s%s;", new Object[]{this.name, this.type, this.type.details.apply(this.size, this.lastModified), this.type.toTail.apply(indent, this.content)});
    }

    public static enum Type {
        REGULAR(BasicFileAttributes::isRegularFile, (x$0, x$1) -> FileInfo.access$500(x$0, x$1), (x$0, x$1) -> FileInfo.access$200(x$0, x$1)),
        DIRECTORY(BasicFileAttributes::isDirectory, (x$0, x$1) -> FileInfo.access$300(x$0, x$1), (x$0, x$1) -> FileInfo.access$400(x$0, x$1)),
        SYMLINK(BasicFileAttributes::isSymbolicLink, (x$0, x$1) -> FileInfo.access$300(x$0, x$1), (x$0, x$1) -> FileInfo.access$200(x$0, x$1)),
        OTHER(Objects::nonNull, (x$0, x$1) -> FileInfo.access$300(x$0, x$1), (x$0, x$1) -> FileInfo.access$200(x$0, x$1)),
        MISSING(Objects::isNull, (x$0, x$1) -> FileInfo.access$300(x$0, x$1), (x$0, x$1) -> FileInfo.access$200(x$0, x$1));

        private final Predicate<BasicFileAttributes> filter;
        private final BiFunction<Long, Instant, String> details;
        private final BiFunction<Integer, List<FileInfo>, String> toTail;

        private Type(Predicate<BasicFileAttributes> filter, BiFunction<Long, Instant, String> details, BiFunction<Integer, List<FileInfo>, String> toTail) {
            this.filter = filter;
            this.details = details;
            this.toTail = toTail;
        }

        static Type of(BasicFileAttributes entry) {
            return Stream.of(Type.values()).filter(type -> null != entry && type.filter.test(entry)).findAny().orElse(MISSING);
        }
    }
}

