/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.testing.titan;

import de.team33.patterns.testing.titan.Context;
import de.team33.patterns.testing.titan.Operation;
import de.team33.patterns.testing.titan.Report;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

@Deprecated
public final class Parallel<R> {
    private final Report.Builder<R> report = new Report.Builder();
    private final AtomicInteger threadCounter = new AtomicInteger(0);
    private final AtomicInteger operationCounter = new AtomicInteger(0);
    private final List<Thread> threads;

    private Parallel(int numberOfThreads, Operation<R> operation) {
        this.threads = Collections.unmodifiableList(IntStream.range(0, numberOfThreads).mapToObj(threadIndex -> this.newThread(threadIndex, operation)).collect(Collectors.toList()));
    }

    public static <R> Report<R> report(int numberOfThreads, Operation<R> operation) {
        return super.report();
    }

    public static <R> Stream<R> stream(int numberOfThreads, Operation<R> operation) throws Exception {
        return Parallel.report(numberOfThreads, operation).reThrow(Error.class, new Class[0]).reThrow(Exception.class, new Class[0]).stream();
    }

    private Thread newThread(int threadIndex, Operation<R> operation) {
        return new Thread(this.newRunnable(operation), this + ":" + threadIndex);
    }

    private Runnable newRunnable(Operation<R> operation) {
        return () -> {
            int threadIndex = this.threadCounter.getAndIncrement();
            for (int loop = 0; loop == 0 || this.threadCounter.get() < this.threads.size(); ++loop) {
                try {
                    this.report.add(operation.operate(new Context(threadIndex, this.operationCounter.getAndIncrement(), loop)));
                    continue;
                }
                catch (Throwable e) {
                    this.report.add(e);
                }
            }
        };
    }

    private Parallel<R> startThreads() {
        for (Thread thread : this.threads) {
            thread.start();
        }
        return this;
    }

    private Parallel<R> joinThreads() {
        for (Thread thread : this.threads) {
            try {
                thread.join();
            }
            catch (InterruptedException caught) {
                Thread.currentThread().interrupt();
                this.report.add(caught);
            }
        }
        return this;
    }

    private Report<R> report() {
        return this.report.build();
    }
}

