/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.testing.titan.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

@Deprecated
public final class FileIO {
    private static final String CANNOT_COPY_RESOURCE = "cannot copy resource%n    resource name   : %s%n    referring class : %s%n    target path     : %s%n";
    private static final String CANNOT_COPY_FILE = "cannot copy file%n    source path : %s%n    target path : %s%n";

    private FileIO() {
    }

    public static void copy(Class<?> refClass, String rsrcName, Path target) {
        try (InputStream in = refClass.getResourceAsStream(rsrcName);){
            FileIO.copy(in, target);
        }
        catch (IOException | NullPointerException e) {
            throw new IllegalArgumentException(String.format(CANNOT_COPY_RESOURCE, rsrcName, refClass, target), e);
        }
    }

    public static void copy(Path source, Path target) {
        try (InputStream in = Files.newInputStream(source, new OpenOption[0]);){
            FileIO.copy(in, target);
            Files.setLastModifiedTime(target, Files.getLastModifiedTime(source, new LinkOption[0]));
            Files.setLastModifiedTime(target, Files.getLastModifiedTime(source, new LinkOption[0]));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format(CANNOT_COPY_FILE, source, target), e);
        }
    }

    private static void copy(InputStream in, Path target) throws IOException {
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
    }
}

