/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.testing.titan.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

@Deprecated
public final class ZipIO {
    private static final String CANNOT_UNZIP_RESOURCE = "cannot unzip resource%n    resource name   : %s%n    referring class : %s%n    target path     : %s%n";
    private static final String CANNOT_UNZIP_FILE = "cannot unzip file%n    zip file    : %s%n    target path : %s%n";

    private ZipIO() {
    }

    public static void unzip(Class<?> refClass, String rsrcName, Path target) {
        try (InputStream in = refClass.getResourceAsStream(rsrcName);){
            ZipIO.unzip(in, target);
        }
        catch (IOException | NullPointerException e) {
            throw new IllegalArgumentException(String.format(CANNOT_UNZIP_RESOURCE, rsrcName, refClass, target), e);
        }
    }

    public static void unzip(Path srcZip, Path target) {
        try (InputStream in = Files.newInputStream(srcZip, new OpenOption[0]);){
            ZipIO.unzip(in, target);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format(CANNOT_UNZIP_FILE, srcZip, target), e);
        }
    }

    private static void unzip(InputStream in, Path targetRoot) throws IOException {
        try (ZipInputStream zipIn = new ZipInputStream(in);){
            int counter = 0;
            ZipEntry entry = zipIn.getNextEntry();
            while (null != entry) {
                if (!entry.isDirectory()) {
                    Path target = targetRoot.resolve(entry.getName());
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    Files.copy(zipIn, target, StandardCopyOption.REPLACE_EXISTING);
                    Files.setLastModifiedTime(target, entry.getLastModifiedTime());
                }
                ++counter;
                entry = zipIn.getNextEntry();
            }
            if (0 == counter) {
                throw new IOException("zip file is empty or no zip file");
            }
        }
    }
}

