/*
 * Decompiled with CFR 0.152.
 */
package de.team33.sphinx.alpha.option;

import de.team33.patterns.building.elara.LateBuilder;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class GridBag {
    private GridBag() {
    }

    public static GridBagLayout layout() {
        return new GridBagLayout();
    }

    public static Insets insets(int uniValue) {
        return GridBag.insets(uniValue, uniValue, uniValue, uniValue);
    }

    public static Insets insets(int horizontal, int vertical) {
        return GridBag.insets(vertical, horizontal, vertical, horizontal);
    }

    public static Insets insets(int top, int left, int bottom, int right) {
        return new Insets(top, left, bottom, right);
    }

    public static enum Fill {
        NONE(0),
        BOTH(1),
        HORIZONTAL(2),
        VERTICAL(3);

        private final int value;

        private Fill(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public static Fill of(int value) {
            return Stream.of(Fill.values()).filter(fill -> fill.value == value).findAny().orElseThrow(() -> new NoSuchElementException("No Fill found for value " + value));
        }
    }

    public static enum Anchor {
        CENTER(10),
        NORTH(11),
        NORTHEAST(12),
        EAST(13),
        SOUTHEAST(14),
        SOUTH(15),
        SOUTHWEST(16),
        WEST(17),
        NORTHWEST(18),
        PAGE_START(19),
        PAGE_END(20),
        LINE_START(21),
        LINE_END(22),
        FIRST_LINE_START(23),
        FIRST_LINE_END(24),
        LAST_LINE_START(25),
        LAST_LINE_END(26),
        BASELINE(256),
        BASELINE_LEADING(512),
        BASELINE_TRAILING(768),
        ABOVE_BASELINE(1024),
        ABOVE_BASELINE_LEADING(1280),
        ABOVE_BASELINE_TRAILING(1536),
        BELOW_BASELINE(1792),
        BELOW_BASELINE_LEADING(2048),
        BELOW_BASELINE_TRAILING(2304);

        private final int value;

        private Anchor(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public static Anchor of(int value) {
            return Stream.of(Anchor.values()).filter(anchor -> anchor.value == value).findAny().orElseThrow(() -> new NoSuchElementException("No Anchor found for value " + value));
        }
    }

    public static final class Constraints {
        private Constraints() {
        }

        public static Template template() {
            return new Template(new GridBagConstraints());
        }

        public static Builder builder() {
            return new Builder(GridBagConstraints::new);
        }

        public static final class Builder
        extends LateBuilder<GridBagConstraints, Builder> {
            private Builder(Supplier<GridBagConstraints> newResult) {
                super(newResult, Builder.class);
            }

            public final Template template() {
                return new Template((GridBagConstraints)this.build());
            }

            public final Builder setGridX(int gridX) {
                return (Builder)this.setup(gbc -> {
                    gbc.gridx = gridX;
                });
            }

            public final Builder setGridY(int gridY) {
                return (Builder)this.setup(gbc -> {
                    gbc.gridy = gridY;
                });
            }

            public final Builder setGridWidth(int gridWidth) {
                return (Builder)this.setup(gbc -> {
                    gbc.gridwidth = gridWidth;
                });
            }

            public final Builder setGridHeight(int gridHeight) {
                return (Builder)this.setup(gbc -> {
                    gbc.gridheight = gridHeight;
                });
            }

            public final Builder setWeightX(double weightX) {
                return (Builder)this.setup(gbc -> {
                    gbc.weightx = weightX;
                });
            }

            public final Builder setWeightY(double weightY) {
                return (Builder)this.setup(gbc -> {
                    gbc.weighty = weightY;
                });
            }

            public final Builder setWeightXY(double weightXY) {
                return this.setWeightX(weightXY).setWeightY(weightXY);
            }

            public final Builder setAnchor(Anchor anchor) {
                return (Builder)this.setup(gbc -> {
                    gbc.anchor = anchor.getValue();
                });
            }

            public final Builder setFill(Fill fill) {
                return (Builder)this.setup(gbc -> {
                    gbc.fill = fill.getValue();
                });
            }

            public final Builder setInsets(Insets insets) {
                return (Builder)this.setup(gbc -> {
                    gbc.insets = insets;
                });
            }

            public final Builder setIPadX(int iPadX) {
                return (Builder)this.setup(gbc -> {
                    gbc.ipadx = iPadX;
                });
            }

            public final Builder setIPadY(int iPadY) {
                return (Builder)this.setup(gbc -> {
                    gbc.ipady = iPadY;
                });
            }

            public final Builder setIPadXY(int iPadXY) {
                return this.setIPadX(iPadXY).setIPadY(iPadXY);
            }
        }

        public static final class Template {
            private final GridBagConstraints backing;

            private Template(GridBagConstraints backing) {
                this.backing = backing;
            }

            public final GridBagConstraints get() {
                return (GridBagConstraints)this.backing.clone();
            }

            public final GridBagConstraints get(int gridX, int gridY) {
                return (GridBagConstraints)this.builder().setGridX(gridX).setGridY(gridY).build();
            }

            public final GridBagConstraints get(int gridX, int gridY, double weightXY) {
                return (GridBagConstraints)this.builder().setGridX(gridX).setGridY(gridY).setWeightXY(weightXY).build();
            }

            public final GridBagConstraints get(int gridX, int gridY, double weightX, double weightY) {
                return (GridBagConstraints)this.builder().setGridX(gridX).setGridY(gridY).setWeightX(weightX).setWeightY(weightY).build();
            }

            public final GridBagConstraints getY(int gridY) {
                return this.getY(gridY, this.backing.weighty);
            }

            public final GridBagConstraints getY(int gridY, double weightY) {
                return (GridBagConstraints)this.builder().setGridY(gridY).setWeightY(weightY).build();
            }

            public final GridBagConstraints getX(int gridX) {
                return this.getX(gridX, this.backing.weightx);
            }

            public final GridBagConstraints getX(int gridX, double weightX) {
                return (GridBagConstraints)this.builder().setGridX(gridX).setWeightX(weightX).build();
            }

            public final Builder builder() {
                return new Builder(this::get);
            }
        }
    }
}

