/*
 * Decompiled with CFR 0.152.
 */
package de.team33.sphinx.alpha.option;

import de.team33.sphinx.alpha.activity.Event;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.function.Supplier;
import java.util.prefs.Preferences;

public class BackedBounds {
    private static final String X = "x";
    private static final String Y = "y";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String STATE = "xState";
    private final Preferences backing;
    private final Rectangle fallback;

    public BackedBounds(Preferences backing, Rectangle fallback) {
        this.backing = backing;
        this.fallback = fallback;
    }

    public final Point getLocation() {
        return new Point(this.backing.getInt(X, this.fallback.x), this.backing.getInt(Y, this.fallback.y));
    }

    public final void setLocation(Point point) {
        this.backing.putInt(X, point.x);
        this.backing.putInt(Y, point.y);
    }

    public final void setLocationIfNormal(Point point) {
        this.setLocationIfNormal(() -> point);
    }

    public final void setLocationIfNormal(Supplier<? extends Point> point) {
        if (0 == this.getState()) {
            this.setLocation(point.get());
        }
    }

    public final Dimension getSize() {
        return new Dimension(this.backing.getInt(WIDTH, this.fallback.width), this.backing.getInt(HEIGHT, this.fallback.height));
    }

    public final void setSize(Dimension size) {
        this.backing.putInt(WIDTH, size.width);
        this.backing.putInt(HEIGHT, size.height);
    }

    public final void setSizeIfNormal(Dimension size) {
        this.setSizeIfNormal(() -> size);
    }

    public final void setSizeIfNormal(Supplier<? extends Dimension> size) {
        if (0 == this.getState()) {
            this.setSize(size.get());
        }
    }

    public final Rectangle getBounds() {
        return new Rectangle(this.getLocation(), this.getSize());
    }

    public final void setBounds(Rectangle bounds) {
        this.setLocation(bounds.getLocation());
        this.setSize(bounds.getSize());
    }

    public final void setBoundsIfNormal(Rectangle bounds) {
        this.setBoundsIfNormal(() -> bounds);
    }

    public final void setBoundsIfNormal(Supplier<? extends Rectangle> bounds) {
        if (0 == this.getState()) {
            this.setBounds(bounds.get());
        }
    }

    public final int getState() {
        return this.backing.getInt(STATE, 0);
    }

    public final void setState(int state) {
        this.backing.putInt(STATE, state);
    }

    public final void setupFrame(Frame frame) {
        frame.setExtendedState(this.getState());
        this.setupWindow(frame);
    }

    public final void setupWindow(Window window) {
        this.setupComponent(window);
        Event.WINDOW_STATE_CHANGED.add(window, e -> this.setState(e.getNewState()));
    }

    public final void setupComponent(Component component) {
        component.setBounds(this.getBounds());
        Event.COMPONENT_MOVED.add(component, e -> this.setLocationIfNormal(e.getComponent().getLocation()));
        Event.COMPONENT_RESIZED.add(component, e -> this.setSizeIfNormal(e.getComponent().getSize()));
    }
}

