/*
 * Decompiled with CFR 0.152.
 */
package de.team33.sphinx.alpha.model;

import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataListener;

public final class ComboListModel<E>
implements ComboBoxModel<E> {
    private static final Logger LOG = Logger.getLogger(ComboListModel.class.getCanonicalName());
    private static final Backing NO_BACKING = new Backing(() -> null, item -> {});
    private final E[] items;
    private final Backing<E> backing;

    private ComboListModel(Backing<E> backing, E[] items) {
        this.items = items;
        this.backing = backing;
    }

    private ComboListModel(E[] items) {
        this(ComboListModel.noBacking(), items);
    }

    private ComboListModel(ComboListModel<E> origin, Backing<E> backing) {
        this(backing, origin.items);
    }

    private static <E> Backing<E> noBacking() {
        return NO_BACKING;
    }

    public static <E extends Enum<?>> ComboListModel<E> of(Class<E> enumClass) {
        return new ComboListModel<E>(enumClass.getEnumConstants());
    }

    @SafeVarargs
    public static <E> ComboListModel<E> ofItems(E ... items) {
        return new ComboListModel<E>(items);
    }

    public ComboListModel<E> setBacking(Supplier<? extends E> getter, Consumer<? super E> setter) {
        return new ComboListModel(new Backing(getter, setter), this.items);
    }

    @Override
    public E getSelectedItem() {
        return this.backing.getter.get();
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.backing.setter.accept(anItem);
    }

    @Override
    public int getSize() {
        return this.items.length;
    }

    @Override
    public E getElementAt(int index) {
        return this.items[index];
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        LOG.info(() -> "EnumModel.addListDataListener - ignored: " + l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        LOG.info(() -> "EnumModel.removeListDataListener - ignored: " + l);
    }

    private static class Backing<E> {
        final Supplier<? extends E> getter;
        final Consumer<? super E> setter;

        private Backing(Supplier<? extends E> getter, Consumer<? super E> setter) {
            this.getter = getter;
            this.setter = setter;
        }
    }
}

