package de.team33.sphinx.metis;

import de.team33.patterns.building.elara.LateBuilder;

import javax.swing.*;
import javax.swing.plaf.SeparatorUI;
import java.util.function.Supplier;

/**
 * Utility class to handle {@link JSeparator}s.
 */
@SuppressWarnings("unused")
public final class JSeparators {

    private JSeparators() {
    }

    /**
     * Returns a new {@link Builder} for target instances of type {@link JSeparator}.
     */
    public static Builder<JSeparator> builder() {
        return new Builder<>(JSeparator::new, Builder.class);
    }

    /**
     * Returns a new {@link Builder} for target instances as supplied by the given {@link Supplier}.
     * 
     * @param <T> The final type of the target instances, at least {@link JSeparator}.
     */
    public static <T extends JSeparator> Builder<T> builder(final Supplier<T> newTarget) {
        return new Builder<>(newTarget, Builder.class);
    }

    /**
     * Returns a new {@link Charger} for a given target instance.
     * 
     * @param <T> The final type of the target instance, at least {@link JSeparator}.
     */
    public static <T extends JSeparator> Charger<T> charger(final T target) {
        return new Charger<>(target, Charger.class);
    }

    /**
     * Returns a new {@link Setup} for a given {@link JSeparator} instance.
     */
    public static Setup<JSeparator, ?> setup(final JSeparator target) {
        return charger(target);
    }

    /**
     * Builder implementation to build target instances of {@link JSeparator}.
     * 
     * @param <T> The final type of the target instances, at least {@link JSeparator}.
     */
    public static final class Builder<T extends JSeparator>
            extends LateBuilder<T, Builder<T>> implements Setup<T, Builder<T>> {

        @SuppressWarnings("unchecked")
        private Builder(final Supplier<T> newResult, final Class builderClass) {
            super(newResult, builderClass);
        }
    }

    /**
     * Charger implementation to charge target instances of {@link JSeparator}.
     * 
     * @param <T> The final type of the target instance, at least {@link JSeparator}.
     */
    public static final class Charger<T extends JSeparator>
            extends de.team33.patterns.building.elara.Charger<T, Charger<T>>
            implements Setup<T, Charger<T>> {

        @SuppressWarnings("unchecked")
        private Charger(final T target, final Class chargerClass) {
            super(target, chargerClass);
        }
    }

    /**
     * Utility interface to set up a target instance of {@link JSeparator}.
     * 
     * @param <T> The final type of the target instance, at least {@link JSeparator}.
     * @param <S> The final type of the Setup implementation.
     */
    @SuppressWarnings("ClassNameSameAsAncestorName")
    @FunctionalInterface
    public interface Setup<T extends JSeparator, S extends Setup<T, S>> extends JComponents.Setup<T, S> {

        /**
         * @see JSeparator#setOrientation(int)
         */
        default S setOrientation(final int arg0) {
            return setup(result -> result.setOrientation(arg0));
        }

        /**
         * @see JSeparator#setUI(SeparatorUI)
         */
        default S setUI(final SeparatorUI arg0) {
            return setup(result -> result.setUI(arg0));
        }
    }
}
