/*
 * Decompiled with CFR 0.152.
 */
package de.team33.sphinx.metis;

import de.team33.patterns.building.elara.LateBuilder;
import de.team33.sphinx.metis.Frames;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.util.function.Supplier;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.TransferHandler;

public final class JFrames {
    private JFrames() {
    }

    public static Builder<JFrame> builder() {
        return new Builder<JFrame>(JFrame::new, Builder.class);
    }

    public static Builder<JFrame> builder(String title) {
        return new Builder<JFrame>(() -> new JFrame(title), Builder.class);
    }

    public static Builder<JFrame> builder(GraphicsConfiguration gc) {
        return new Builder<JFrame>(() -> new JFrame(gc), Builder.class);
    }

    public static Builder<JFrame> builder(String title, GraphicsConfiguration gc) {
        return new Builder<JFrame>(() -> new JFrame(title, gc), Builder.class);
    }

    public static <F extends JFrame> Builder<F> builder(Supplier<F> newTarget) {
        return new Builder<F>(newTarget, Builder.class);
    }

    public static <F extends JFrame> Charger<F> charger(F target) {
        return new Charger<F>(target, Charger.class);
    }

    public static Setup<JFrame, ?> setup(JFrame target) {
        return JFrames.charger(target);
    }

    public static final class Builder<F extends JFrame>
    extends LateBuilder<F, Builder<F>>
    implements Setup<F, Builder<F>> {
        private Builder(Supplier<F> newResult, Class builderClass) {
            super(newResult, builderClass);
        }
    }

    public static final class Charger<F extends JFrame>
    extends de.team33.patterns.building.elara.Charger<F, Charger<F>>
    implements Setup<F, Charger<F>> {
        private Charger(F target, Class chargerClass) {
            super(target, chargerClass);
        }
    }

    @FunctionalInterface
    public static interface Setup<F extends JFrame, S extends Setup<F, S>>
    extends Frames.Setup<F, S> {
        default public S setContentPane(Container contentPane) {
            return (S)((Setup)this.setup(result -> result.setContentPane(contentPane)));
        }

        default public S setDefaultCloseOperation(int operation) {
            return (S)((Setup)this.setup(result -> result.setDefaultCloseOperation(operation)));
        }

        default public S setGlassPane(Component glassPane) {
            return (S)((Setup)this.setup(result -> result.setGlassPane(glassPane)));
        }

        default public S setJMenuBar(JMenuBar menuBar) {
            return (S)((Setup)this.setup(result -> result.setJMenuBar(menuBar)));
        }

        default public S setLayeredPane(JLayeredPane layeredPane) {
            return (S)((Setup)this.setup(result -> result.setLayeredPane(layeredPane)));
        }

        default public S setTransferHandler(TransferHandler handler) {
            return (S)((Setup)this.setup(result -> result.setTransferHandler(handler)));
        }
    }
}

