/*
 * Decompiled with CFR 0.152.
 */
package de.team33.sphinx.metis;

import de.team33.patterns.building.elara.LateBuilder;
import de.team33.sphinx.metis.JComponents;
import java.awt.Component;
import java.util.function.Supplier;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.plaf.ScrollPaneUI;

public final class JScrollPanes {
    private JScrollPanes() {
    }

    public static Builder<JScrollPane> builder() {
        return new Builder<JScrollPane>(JScrollPane::new, Builder.class);
    }

    public static Builder<JScrollPane> builder(Component content) {
        return new Builder<JScrollPane>(() -> new JScrollPane(content), Builder.class);
    }

    public static Builder<JScrollPane> builder(int vsbPolicy, int hsbPolicy) {
        return new Builder<JScrollPane>(() -> new JScrollPane(vsbPolicy, hsbPolicy), Builder.class);
    }

    public static Builder<JScrollPane> builder(Component content, int vsbPolicy, int hsbPolicy) {
        return new Builder<JScrollPane>(() -> new JScrollPane(content, vsbPolicy, hsbPolicy), Builder.class);
    }

    public static <T extends JScrollPane> Builder<T> builder(Supplier<T> newTarget) {
        return new Builder<T>(newTarget, Builder.class);
    }

    public static <T extends JScrollPane> Charger<T> charger(T target) {
        return new Charger<T>(target, Charger.class);
    }

    public static Setup<JScrollPane, ?> setup(JScrollPane target) {
        return JScrollPanes.charger(target);
    }

    public static final class Builder<T extends JScrollPane>
    extends LateBuilder<T, Builder<T>>
    implements Setup<T, Builder<T>> {
        private Builder(Supplier<T> newResult, Class builderClass) {
            super(newResult, builderClass);
        }
    }

    public static final class Charger<T extends JScrollPane>
    extends de.team33.patterns.building.elara.Charger<T, Charger<T>>
    implements Setup<T, Charger<T>> {
        private Charger(T target, Class chargerClass) {
            super(target, chargerClass);
        }
    }

    @FunctionalInterface
    public static interface Setup<T extends JScrollPane, S extends Setup<T, S>>
    extends JComponents.Setup<T, S> {
        default public S setColumnHeader(JViewport header) {
            return (S)((Setup)this.setup(result -> result.setColumnHeader(header)));
        }

        default public S setColumnHeaderView(Component header) {
            return (S)((Setup)this.setup(result -> result.setColumnHeaderView(header)));
        }

        default public S setCorner(String key, Component corner) {
            return (S)((Setup)this.setup(result -> result.setCorner(key, corner)));
        }

        default public S setHorizontalScrollBar(JScrollBar bar) {
            return (S)((Setup)this.setup(result -> result.setHorizontalScrollBar(bar)));
        }

        default public S setHorizontalScrollBarPolicy(int policy) {
            return (S)((Setup)this.setup(result -> result.setHorizontalScrollBarPolicy(policy)));
        }

        default public S setRowHeader(JViewport header) {
            return (S)((Setup)this.setup(result -> result.setRowHeader(header)));
        }

        default public S setRowHeaderView(Component header) {
            return (S)((Setup)this.setup(result -> result.setRowHeaderView(header)));
        }

        default public S setUI(ScrollPaneUI ui) {
            return (S)((Setup)this.setup(result -> result.setUI(ui)));
        }

        default public S setVerticalScrollBar(JScrollBar bar) {
            return (S)((Setup)this.setup(result -> result.setVerticalScrollBar(bar)));
        }

        default public S setVerticalScrollBarPolicy(int policy) {
            return (S)((Setup)this.setup(result -> result.setVerticalScrollBarPolicy(policy)));
        }

        default public S setViewport(JViewport viewport) {
            return (S)((Setup)this.setup(result -> result.setViewport(viewport)));
        }

        default public S setViewportBorder(Border border) {
            return (S)((Setup)this.setup(result -> result.setViewportBorder(border)));
        }

        default public S setViewportView(Component view) {
            return (S)((Setup)this.setup(result -> result.setViewportView(view)));
        }

        default public S setWheelScrollingEnabled(boolean enabled) {
            return (S)((Setup)this.setup(result -> result.setWheelScrollingEnabled(enabled)));
        }
    }
}

