/*
 * Decompiled with CFR 0.152.
 */
package de.team33.sphinx.metis;

import de.team33.patterns.building.elara.LateBuilder;
import de.team33.sphinx.luna.Channel;
import de.team33.sphinx.luna.Subscription;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class Components {
    private Components() {
    }

    public static <C extends Component> Builder<C> builder(Supplier<C> newTarget) {
        return new Builder<C>(newTarget, Builder.class);
    }

    public static <T extends Component> Charger<T> charger(T target) {
        return new Charger<T>(target, Charger.class);
    }

    public static Setup<Component, ?> setup(Component target) {
        return Components.charger(target);
    }

    public static final class Builder<C extends Component>
    extends LateBuilder<C, Builder<C>>
    implements Setup<C, Builder<C>> {
        private Builder(Supplier<C> newResult, Class builderClass) {
            super(newResult, builderClass);
        }
    }

    public static final class Charger<C extends Component>
    extends de.team33.patterns.building.elara.Charger<C, Charger<C>>
    implements Setup<C, Charger<C>> {
        private Charger(C target, Class chargerClass) {
            super(target, chargerClass);
        }
    }

    @FunctionalInterface
    public static interface Setup<C extends Component, S extends Setup<C, S>>
    extends de.team33.patterns.building.elara.Setup<C, S> {
        default public <M> S subscribe(Channel<? super C, M> channel, Consumer<M> listener) {
            return (S)((Setup)this.setup(c -> channel.subscribe(c, listener)));
        }

        default public <M> S subscribe(Channel<? super C, M> channel, Consumer<M> listener, Consumer<Subscription> collector) {
            return (S)((Setup)this.setup(c -> collector.accept(channel.subscribe(c, listener))));
        }

        default public S add(PopupMenu popup) {
            return (S)((Setup)this.setup(result -> result.add(popup)));
        }

        default public S remove(MenuComponent popup) {
            return (S)((Setup)this.setup(result -> result.remove(popup)));
        }

        default public S setBackground(Color color) {
            return (S)((Setup)this.setup(result -> result.setBackground(color)));
        }

        default public S setBounds(Rectangle r) {
            return (S)((Setup)this.setup(result -> result.setBounds(r)));
        }

        default public S setBounds(int x, int y, int width, int height) {
            return (S)((Setup)this.setup(result -> result.setBounds(x, y, width, height)));
        }

        default public S setComponentOrientation(ComponentOrientation o) {
            return (S)((Setup)this.setup(result -> result.setComponentOrientation(o)));
        }

        default public S setCursor(Cursor cursor) {
            return (S)((Setup)this.setup(result -> result.setCursor(cursor)));
        }

        default public S setDropTarget(DropTarget dt) {
            return (S)((Setup)this.setup(result -> result.setDropTarget(dt)));
        }

        default public S setEnabled(boolean enabled) {
            return (S)((Setup)this.setup(result -> result.setEnabled(enabled)));
        }

        default public S setFocusTraversalKeys(int id, Set<? extends AWTKeyStroke> keystrokes) {
            return (S)((Setup)this.setup(result -> result.setFocusTraversalKeys(id, keystrokes)));
        }

        default public S setFocusTraversalKeysEnabled(boolean focusTraversalKeysEnabled) {
            return (S)((Setup)this.setup(result -> result.setFocusTraversalKeysEnabled(focusTraversalKeysEnabled)));
        }

        default public S setFocusable(boolean focusable) {
            return (S)((Setup)this.setup(result -> result.setFocusable(focusable)));
        }

        default public S setFont(Font font) {
            return (S)((Setup)this.setup(result -> result.setFont(font)));
        }

        default public S setForeground(Color color) {
            return (S)((Setup)this.setup(result -> result.setForeground(color)));
        }

        default public S setIgnoreRepaint(boolean ignoreRepaint) {
            return (S)((Setup)this.setup(result -> result.setIgnoreRepaint(ignoreRepaint)));
        }

        default public S setLocale(Locale locale) {
            return (S)((Setup)this.setup(result -> result.setLocale(locale)));
        }

        default public S setLocation(Point p) {
            return (S)((Setup)this.setup(result -> result.setLocation(p)));
        }

        default public S setLocation(int x, int y) {
            return (S)((Setup)this.setup(result -> result.setLocation(x, y)));
        }

        default public S setMaximumSize(Dimension maximumSize) {
            return (S)((Setup)this.setup(result -> result.setMaximumSize(maximumSize)));
        }

        default public S setMinimumSize(Dimension minimumSize) {
            return (S)((Setup)this.setup(result -> result.setMinimumSize(minimumSize)));
        }

        default public S setName(String name) {
            return (S)((Setup)this.setup(result -> result.setName(name)));
        }

        default public S setPreferredSize(Dimension preferredSize) {
            return (S)((Setup)this.setup(result -> result.setPreferredSize(preferredSize)));
        }

        default public S setSize(Dimension size) {
            return (S)((Setup)this.setup(result -> result.setSize(size)));
        }

        default public S setSize(int width, int height) {
            return (S)((Setup)this.setup(result -> result.setSize(width, height)));
        }

        default public S setVisible(boolean visible) {
            return (S)((Setup)this.setup(result -> result.setVisible(visible)));
        }
    }
}

