/*
 * Decompiled with CFR 0.152.
 */
package de.team33.sphinx.metis;

import de.team33.patterns.building.elara.LateBuilder;
import de.team33.sphinx.metis.JComponents;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.swing.DropMode;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.plaf.TableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public final class JTables {
    private JTables() {
    }

    public static Builder<JTable> builder() {
        return new Builder<JTable>(JTable::new, Builder.class);
    }

    public static Builder<JTable> builder(TableModel model) {
        return new Builder<JTable>(() -> new JTable(model), Builder.class);
    }

    public static Builder<JTable> builder(TableModel tableModel, TableColumnModel columnModel) {
        return new Builder<JTable>(() -> new JTable(tableModel, columnModel), Builder.class);
    }

    public static Builder<JTable> builder(TableModel tableModel, TableColumnModel columnModel, ListSelectionModel selectionModel) {
        return new Builder<JTable>(() -> new JTable(tableModel, columnModel, selectionModel), Builder.class);
    }

    public static <T extends JTable> Builder<T> builder(Supplier<T> newTarget) {
        return new Builder<T>(newTarget, Builder.class);
    }

    public static <T extends JTable> Charger<T> charger(T target) {
        return new Charger<T>(target, Charger.class);
    }

    public static Setup<JTable, ?> setup(JTable target) {
        return JTables.charger(target);
    }

    private static Helper helper(JTable target) {
        return new Helper(target);
    }

    public static void resizeColumns(JTable target) {
        JTables.resizeColumns(target, Integer.MAX_VALUE);
    }

    public static void resizeColumns(JTable target, int maxWidth) {
        JTables.helper(target).resizeColumns(maxWidth);
    }

    public static void resizeColumn(JTable target, int colIndex) {
        JTables.resizeColumn(target, colIndex, Integer.MAX_VALUE);
    }

    public static void resizeColumn(JTable target, int colIndex, int maxWidth) {
        JTables.helper(target).resizeColumn(colIndex, maxWidth);
    }

    public static final class Builder<T extends JTable>
    extends LateBuilder<T, Builder<T>>
    implements Setup<T, Builder<T>> {
        private Builder(Supplier<T> newResult, Class builderClass) {
            super(newResult, builderClass);
        }
    }

    public static final class Charger<T extends JTable>
    extends de.team33.patterns.building.elara.Charger<T, Charger<T>>
    implements Setup<T, Charger<T>> {
        private Charger(T target, Class chargerClass) {
            super(target, chargerClass);
        }
    }

    private record Helper(JTable table) {
        final void resizeColumns(int maxWidth) {
            IntStream.range(0, this.table.getColumnModel().getColumnCount()).forEach(colIndex -> this.resizeColumn(colIndex, maxWidth));
        }

        final void resizeColumn(int colIndex, int maxWidth) {
            TableColumn column = this.table.getColumnModel().getColumn(colIndex);
            TableCellRenderer headRenderer = Optional.ofNullable(column.getHeaderRenderer()).orElseGet(() -> this.table.getTableHeader().getDefaultRenderer());
            Component head = headRenderer.getTableCellRendererComponent(this.table, column.getHeaderValue(), false, false, 0, colIndex);
            int width = IntStream.range(0, this.table.getRowCount()).map(rowIndex -> this.preferredCellWidth(colIndex, rowIndex)).reduce(head.getPreferredSize().width, Integer::max);
            column.setPreferredWidth(Integer.min(maxWidth, width + 8));
        }

        private int preferredCellWidth(int colIndex, int rowIndex) {
            TableCellRenderer cellRenderer = this.table.getCellRenderer(rowIndex, colIndex);
            Component cell = this.table.prepareRenderer(cellRenderer, rowIndex, colIndex);
            return cell.getPreferredSize().width;
        }
    }

    @FunctionalInterface
    public static interface Setup<T extends JTable, S extends Setup<T, S>>
    extends JComponents.Setup<T, S> {
        default public S addColumn(TableColumn column) {
            return (S)((Setup)this.setup(result -> result.addColumn(column)));
        }

        default public S addColumnSelectionInterval(int minIndex, int maxIndex) {
            return (S)((Setup)this.setup(result -> result.addColumnSelectionInterval(minIndex, maxIndex)));
        }

        default public S addRowSelectionInterval(int minIndex, int maxIndex) {
            return (S)((Setup)this.setup(result -> result.addRowSelectionInterval(minIndex, maxIndex)));
        }

        default public S removeColumn(TableColumn column) {
            return (S)((Setup)this.setup(result -> result.removeColumn(column)));
        }

        default public S removeColumnSelectionInterval(int minIndex, int maxIndex) {
            return (S)((Setup)this.setup(result -> result.removeColumnSelectionInterval(minIndex, maxIndex)));
        }

        default public S removeEditor() {
            return (S)((Setup)this.setup(JTable::removeEditor));
        }

        default public S removeRowSelectionInterval(int minIndex, int maxIndex) {
            return (S)((Setup)this.setup(result -> result.removeRowSelectionInterval(minIndex, maxIndex)));
        }

        default public S setAutoCreateColumnsFromModel(boolean autoCreate) {
            return (S)((Setup)this.setup(result -> result.setAutoCreateColumnsFromModel(autoCreate)));
        }

        default public S setAutoCreateRowSorter(boolean autoCreate) {
            return (S)((Setup)this.setup(result -> result.setAutoCreateRowSorter(autoCreate)));
        }

        default public S setAutoResizeMode(int mode) {
            return (S)((Setup)this.setup(result -> result.setAutoResizeMode(mode)));
        }

        default public S setCellEditor(TableCellEditor editor) {
            return (S)((Setup)this.setup(result -> result.setCellEditor(editor)));
        }

        default public S setCellSelectionEnabled(boolean enabled) {
            return (S)((Setup)this.setup(result -> result.setCellSelectionEnabled(enabled)));
        }

        default public S setColumnModel(TableColumnModel model) {
            return (S)((Setup)this.setup(result -> result.setColumnModel(model)));
        }

        default public S setColumnSelectionAllowed(boolean allowed) {
            return (S)((Setup)this.setup(result -> result.setColumnSelectionAllowed(allowed)));
        }

        default public S setColumnSelectionInterval(int minIndex, int maxIndex) {
            return (S)((Setup)this.setup(result -> result.setColumnSelectionInterval(minIndex, maxIndex)));
        }

        default public S setDefaultEditor(Class<?> columnClass, TableCellEditor editor) {
            return (S)((Setup)this.setup(result -> result.setDefaultEditor(columnClass, editor)));
        }

        default public S setDefaultRenderer(Class<?> columnClass, TableCellRenderer renderer) {
            return (S)((Setup)this.setup(result -> result.setDefaultRenderer(columnClass, renderer)));
        }

        default public S setDragEnabled(boolean enabled) {
            return (S)((Setup)this.setup(result -> result.setDragEnabled(enabled)));
        }

        default public S setDropMode(DropMode mode) {
            return (S)((Setup)this.setup(result -> result.setDropMode(mode)));
        }

        default public S setEditingColumn(int index) {
            return (S)((Setup)this.setup(result -> result.setEditingColumn(index)));
        }

        default public S setEditingRow(int index) {
            return (S)((Setup)this.setup(result -> result.setEditingRow(index)));
        }

        default public S setFillsViewportHeight(boolean height) {
            return (S)((Setup)this.setup(result -> result.setFillsViewportHeight(height)));
        }

        default public S setGridColor(Color color) {
            return (S)((Setup)this.setup(result -> result.setGridColor(color)));
        }

        default public S setInterCellSpacing(Dimension spacing) {
            return (S)((Setup)this.setup(result -> result.setIntercellSpacing(spacing)));
        }

        default public S setModel(TableModel model) {
            return (S)((Setup)this.setup(result -> result.setModel(model)));
        }

        default public S setPreferredScrollableViewportSize(Dimension size) {
            return (S)((Setup)this.setup(result -> result.setPreferredScrollableViewportSize(size)));
        }

        default public S setRowHeight(int height) {
            return (S)((Setup)this.setup(result -> result.setRowHeight(height)));
        }

        default public S setRowHeight(int index, int height) {
            return (S)((Setup)this.setup(result -> result.setRowHeight(index, height)));
        }

        default public S setRowMargin(int margin) {
            return (S)((Setup)this.setup(result -> result.setRowMargin(margin)));
        }

        default public S setRowSelectionAllowed(boolean allowed) {
            return (S)((Setup)this.setup(result -> result.setRowSelectionAllowed(allowed)));
        }

        default public S setRowSelectionInterval(int minIndex, int maxIndex) {
            return (S)((Setup)this.setup(result -> result.setRowSelectionInterval(minIndex, maxIndex)));
        }

        default public S setRowSorter(RowSorter<? extends TableModel> sorter) {
            return (S)((Setup)this.setup(result -> result.setRowSorter(sorter)));
        }

        default public S setSelectionBackground(Color color) {
            return (S)((Setup)this.setup(result -> result.setSelectionBackground(color)));
        }

        default public S setSelectionForeground(Color color) {
            return (S)((Setup)this.setup(result -> result.setSelectionForeground(color)));
        }

        default public S setSelectionMode(int mode) {
            return (S)((Setup)this.setup(result -> result.setSelectionMode(mode)));
        }

        default public S setSelectionModel(ListSelectionModel model) {
            return (S)((Setup)this.setup(result -> result.setSelectionModel(model)));
        }

        default public S setShowGrid(boolean show) {
            return (S)((Setup)this.setup(result -> result.setShowGrid(show)));
        }

        default public S setShowHorizontalLines(boolean show) {
            return (S)((Setup)this.setup(result -> result.setShowHorizontalLines(show)));
        }

        default public S setShowVerticalLines(boolean show) {
            return (S)((Setup)this.setup(result -> result.setShowVerticalLines(show)));
        }

        default public S setSurrendersFocusOnKeystroke(boolean surrenders) {
            return (S)((Setup)this.setup(result -> result.setSurrendersFocusOnKeystroke(surrenders)));
        }

        default public S setTableHeader(JTableHeader header) {
            return (S)((Setup)this.setup(result -> result.setTableHeader(header)));
        }

        default public S setUI(TableUI ui) {
            return (S)((Setup)this.setup(result -> result.setUI(ui)));
        }

        default public S setUpdateSelectionOnSort(boolean update) {
            return (S)((Setup)this.setup(result -> result.setUpdateSelectionOnSort(update)));
        }

        default public S setValueAt(Object value, int rowIndex, int colIndex) {
            return (S)((Setup)this.setup(result -> result.setValueAt(value, rowIndex, colIndex)));
        }
    }
}

