/*
 * Decompiled with CFR 0.152.
 */
package de.team33.testing.async.thebe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Report<R> {
    private final List<R> results;
    private final List<Throwable> caught;

    private Report(Builder<R> builder) {
        this.results = Collections.unmodifiableList(new ArrayList(builder.results));
        this.caught = Collections.unmodifiableList(new ArrayList<Throwable>(builder.caught));
    }

    public final List<R> list() {
        return this.results;
    }

    public Stream<R> stream() {
        return this.results.stream();
    }

    public final List<Throwable> getCaught() {
        return this.caught;
    }

    @SafeVarargs
    public final <X extends Throwable> List<X> getCaught(Class<X> xClass, Class<? extends X> ... ignorable) {
        return this.streamCaught(xClass, ignorable).collect(Collectors.toList());
    }

    @SafeVarargs
    private final <X extends Throwable> Stream<X> streamCaught(Class<X> xClass, Class<? extends X> ... ignorable) {
        return this.caught.stream().filter(xClass::isInstance).map(xClass::cast).filter(throwable -> Stream.of(ignorable).noneMatch(iClass -> iClass.isInstance(throwable)));
    }

    @SafeVarargs
    public final <X extends Throwable> Report<R> reThrow(Class<X> xClass, Class<? extends X> ... ignorable) throws X {
        Throwable caught = this.streamCaught(xClass, ignorable).findAny().orElse(null);
        if (null != caught) {
            this.streamCaught(Throwable.class, new Class[0]).filter(more -> more != caught).forEach(caught::addSuppressed);
            throw caught;
        }
        return this;
    }

    public final Report<R> reThrowAny() throws Exception {
        return this.reThrow(Error.class, new Class[0]).reThrow(Exception.class, new Class[0]);
    }

    public final int size() {
        return this.results.size();
    }

    static class Builder<R> {
        final List<Throwable> caught = Collections.synchronizedList(new LinkedList());
        final List<R> results = Collections.synchronizedList(new LinkedList());

        Builder() {
        }

        final Report<R> build() {
            return new Report(this);
        }

        final Builder<R> add(Throwable caught) {
            this.caught.add(caught);
            return this;
        }

        final Builder<R> add(R result) {
            this.results.add(result);
            return this;
        }
    }
}

