/*
 * Decompiled with CFR 0.152.
 */
package de.team33.testing.async.thebe;

import de.team33.patterns.exceptional.dione.XFunction;
import de.team33.testing.async.thebe.Context;
import de.team33.testing.async.thebe.Report;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class Parallel<R> {
    private final Report.Builder<R> report = new Report.Builder();
    private final AtomicInteger threadCounter = new AtomicInteger(0);
    private final AtomicInteger operationCounter = new AtomicInteger(0);
    private final List<Thread> threads;

    private Parallel(int numberOfThreads, XFunction<Context, R, ?> operation) {
        this.threads = Collections.unmodifiableList(IntStream.range(0, numberOfThreads).mapToObj(threadIndex -> this.newThread(threadIndex, operation)).collect(Collectors.toList()));
    }

    public static <R> Report<R> report(int numberOfThreads, XFunction<Context, R, ?> operation) {
        return super.report();
    }

    public static <R> Stream<R> stream(int numberOfThreads, XFunction<Context, R, ?> operation) throws Exception {
        return Parallel.report(numberOfThreads, operation).reThrow(Error.class, new Class[0]).reThrow(Exception.class, new Class[0]).stream();
    }

    private Thread newThread(int threadIndex, XFunction<Context, R, ?> operation) {
        return new Thread(this.newRunnable(operation), this + ":" + threadIndex);
    }

    private Runnable newRunnable(XFunction<Context, R, ?> operation) {
        return () -> {
            int threadIndex = this.threadCounter.getAndIncrement();
            for (int loop = 0; loop == 0 || this.threadCounter.get() < this.threads.size(); ++loop) {
                try {
                    this.report.add(operation.apply((Object)new Context(threadIndex, this.operationCounter.getAndIncrement(), loop)));
                    continue;
                }
                catch (Throwable e) {
                    this.report.add(e);
                }
            }
        };
    }

    private Parallel<R> startThreads() {
        for (Thread thread : this.threads) {
            thread.start();
        }
        return this;
    }

    private Parallel<R> joinThreads() {
        for (Thread thread : this.threads) {
            try {
                thread.join();
            }
            catch (InterruptedException caught) {
                Thread.currentThread().interrupt();
                this.report.add(caught);
            }
        }
        return this;
    }

    private Report<R> report() {
        return this.report.build();
    }
}

