/*
 * Decompiled with CFR 0.152.
 */
package de.team33.testing.io.hydra;

import de.team33.patterns.io.deimos.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;

public final class FileIO {
    private FileIO() {
    }

    private static Void copy(InputStream in, FileTime lastModified, Path target) throws IOException {
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
        Files.setLastModifiedTime(target, lastModified);
        return null;
    }

    public static void copy(Class<?> refClass, String rsrcName, Path target) {
        Resource.by(refClass, (String)rsrcName).readByteStream(in -> FileIO.copy(in, FileTime.from(Instant.now()), target));
    }

    public static void copy(Path source, Path target) {
        Resource.by((Path)source).readByteStream(in -> FileIO.copy(in, Files.getLastModifiedTime(source, new LinkOption[0]), target));
    }
}

