/*
 * Decompiled with CFR 0.152.
 */
package de.team33.testing.io.hydra;

import de.team33.patterns.io.deimos.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ZipIO {
    private static final String CANNOT_UNZIP_RESOURCE = "cannot unzip resource%n    resource name   : %s%n    referring class : %s%n    target path     : %s%n";
    private static final String CANNOT_UNZIP_FILE = "cannot unzip file%n    zip file    : %s%n    target path : %s%n";

    private ZipIO() {
    }

    private static Void unzip(InputStream in, Path targetRoot) throws IOException {
        try (ZipInputStream zipIn = new ZipInputStream(in);){
            int counter = 0;
            ZipEntry entry = zipIn.getNextEntry();
            while (null != entry) {
                if (!entry.isDirectory()) {
                    Path target = targetRoot.resolve(entry.getName());
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    Files.copy(zipIn, target, StandardCopyOption.REPLACE_EXISTING);
                    Files.setLastModifiedTime(target, entry.getLastModifiedTime());
                }
                ++counter;
                entry = zipIn.getNextEntry();
            }
            if (0 == counter) {
                throw new IOException("zip file is empty or no zip file");
            }
        }
        return null;
    }

    public static void unzip(Class<?> referringClass, String resourceName, Path target) {
        Resource.by(referringClass, (String)resourceName).readByteStream(in -> ZipIO.unzip(in, target));
    }

    public static void unzip(Path zipPath, Path target) {
        Resource.by((Path)zipPath).readByteStream(in -> ZipIO.unzip(in, target));
    }
}

