/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.terrestris.shoguncore.model.File;
import de.terrestris.shoguncore.model.PersistentObject;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;

@Entity
@Table
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Plugin
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    private String name;
    @Column(unique=true, nullable=false)
    private String className;
    @Column(unique=true)
    private String xtype;
    @Type(type="text")
    private String sourceCode;
    @Type(type="text")
    private String styleSheet;
    private Boolean systemPlugin;
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    @JoinTable(joinColumns={@JoinColumn(name="PLUGIN_ID")}, inverseJoinColumns={@JoinColumn(name="FILE_ID")})
    @JsonIgnore
    private Set<File> fileUploads = new HashSet<File>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(unique=true, nullable=false)
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getXtype() {
        return this.xtype;
    }

    public void setXtype(String xtype) {
        this.xtype = xtype;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String getStyleSheet() {
        return this.styleSheet;
    }

    public void setStyleSheet(String styleSheet) {
        this.styleSheet = styleSheet;
    }

    public Boolean getSystemPlugin() {
        return this.systemPlugin;
    }

    public void setSystemPlugin(Boolean systemPlugin) {
        this.systemPlugin = systemPlugin;
    }

    public Set<File> getFileUploads() {
        return this.fileUploads;
    }

    public void setFileUploads(Set<File> fileUploads) {
        this.fileUploads = fileUploads;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(47, 19).appendSuper(super.hashCode()).append((Object)this.getName()).append((Object)this.getClassName()).append((Object)this.getXtype()).append((Object)this.getSourceCode()).append((Object)this.getStyleSheet()).append((Object)this.getSystemPlugin()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Plugin)) {
            return false;
        }
        Plugin other = (Plugin)obj;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getName(), (Object)other.getName()).append((Object)this.getClassName(), (Object)other.getClassName()).append((Object)this.getXtype(), (Object)other.getXtype()).append((Object)this.getSourceCode(), (Object)other.getSourceCode()).append((Object)this.getStyleSheet(), (Object)other.getStyleSheet()).append((Object)this.getSystemPlugin(), (Object)other.getSystemPlugin()).isEquals();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE).appendSuper(super.toString()).append("name", (Object)this.name).append("className", (Object)this.className).append("xtype", (Object)this.xtype).append("stylesheet", (Object)this.styleSheet).append("systemPlugin", (Object)this.systemPlugin).toString();
    }
}

