/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.model.layer;

import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.model.layer.appearance.LayerAppearance;
import de.terrestris.shoguncore.model.layer.source.LayerDataSource;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table
@Inheritance(strategy=InheritanceType.JOINED)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Layer
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    @ManyToOne
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private LayerDataSource source;
    @ManyToOne
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private LayerAppearance appearance;

    public Layer() {
    }

    public Layer(String name) {
        this.name = name;
    }

    public Layer(String name, LayerDataSource source, LayerAppearance appearance) {
        this.name = name;
        this.source = source;
        this.appearance = appearance;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LayerDataSource getSource() {
        return this.source;
    }

    public void setSource(LayerDataSource source) {
        this.source = source;
    }

    public LayerAppearance getAppearance() {
        return this.appearance;
    }

    public void setAppearance(LayerAppearance appearance) {
        this.appearance = appearance;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(29, 13).appendSuper(super.hashCode()).append((Object)this.getName()).append((Object)this.getDescription()).append((Object)this.getSource()).append((Object)this.getAppearance()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Layer)) {
            return false;
        }
        Layer other = (Layer)obj;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getName(), (Object)other.getName()).append((Object)this.getDescription(), (Object)other.getDescription()).append((Object)this.getSource(), (Object)other.getSource()).append((Object)this.getAppearance(), (Object)other.getAppearance()).isEquals();
    }
}

