/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.model.map;

import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.model.layer.util.Extent;
import java.awt.geom.Point2D;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class MapConfig
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    private String name;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="x", column=@Column(name="CENTER_X")), @AttributeOverride(name="y", column=@Column(name="CENTER_Y"))})
    private Point2D.Double center;
    @ManyToOne
    private Extent extent;
    @ElementCollection
    @CollectionTable(name="MAPCONFIG_RESOLUTION", joinColumns={@JoinColumn(name="MAPCONFIG_ID")})
    @Column(name="RESOLUTION")
    @OrderColumn(name="IDX")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private List<Double> resolutions;
    private Integer zoom;
    private Double resolution;
    private Double maxResolution;
    private Double minResolution;
    private Double rotation;
    private String projection;

    public MapConfig() {
    }

    public MapConfig(String name, Point2D.Double center, Extent extent, List<Double> resolutions, Integer zoom, Double maxResolution, Double minResolution, Double rotation, String projection) {
        this.name = name;
        this.center = center;
        this.extent = extent;
        this.resolutions = resolutions;
        this.zoom = zoom;
        this.maxResolution = maxResolution;
        this.minResolution = minResolution;
        this.rotation = rotation;
        this.projection = projection;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Point2D getCenter() {
        return this.center;
    }

    public void setCenter(Point2D.Double center) {
        this.center = center;
    }

    public Extent getExtent() {
        return this.extent;
    }

    public void setExtent(Extent extent) {
        this.extent = extent;
    }

    public List<Double> getResolutions() {
        return this.resolutions;
    }

    public void setResolutions(List<Double> resolutions) {
        this.resolutions = resolutions;
    }

    public Integer getZoom() {
        return this.zoom;
    }

    public void setZoom(Integer zoom) {
        this.zoom = zoom;
    }

    public Double getResolution() {
        return this.resolution;
    }

    public void setResolution(Double resolution) {
        this.resolution = resolution;
    }

    public Double getMaxResolution() {
        return this.maxResolution;
    }

    public void setMaxResolution(Double maxResolution) {
        this.maxResolution = maxResolution;
    }

    public Double getMinResolution() {
        return this.minResolution;
    }

    public void setMinResolution(Double minResolution) {
        this.minResolution = minResolution;
    }

    public Double getRotation() {
        return this.rotation;
    }

    public void setRotation(Double rotation) {
        this.rotation = rotation;
    }

    public String getProjection() {
        return this.projection;
    }

    public void setProjection(String projection) {
        this.projection = projection;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(5, 13).appendSuper(super.hashCode()).append((Object)this.getName()).append((Object)this.getCenter()).append((Object)this.getExtent()).append(this.getResolutions()).append((Object)this.getZoom()).append((Object)this.getResolution()).append((Object)this.getMaxResolution()).append((Object)this.getMinResolution()).append((Object)this.getRotation()).append((Object)this.getProjection()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MapConfig)) {
            return false;
        }
        MapConfig other = (MapConfig)obj;
        return new EqualsBuilder().append((Object)this.getName(), (Object)other.getName()).append((Object)this.getCenter(), (Object)other.getCenter()).append((Object)this.getExtent(), (Object)other.getExtent()).append(this.getResolutions(), other.getResolutions()).append((Object)this.getZoom(), (Object)other.getZoom()).append((Object)this.getResolution(), (Object)other.getResolution()).append((Object)this.getMaxResolution(), (Object)other.getMaxResolution()).append((Object)this.getMinResolution(), (Object)other.getMinResolution()).append((Object)this.getRotation(), (Object)other.getRotation()).append((Object)this.getProjection(), (Object)other.getProjection()).isEquals();
    }
}

