/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.security.access.factory;

import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.model.Role;
import de.terrestris.shoguncore.model.User;
import de.terrestris.shoguncore.model.UserGroup;
import de.terrestris.shoguncore.model.interceptor.InterceptorRule;
import de.terrestris.shoguncore.model.layer.appearance.LayerAppearance;
import de.terrestris.shoguncore.model.layer.source.LayerDataSource;
import de.terrestris.shoguncore.model.layer.util.Extent;
import de.terrestris.shoguncore.model.layer.util.TileGrid;
import de.terrestris.shoguncore.model.layout.Layout;
import de.terrestris.shoguncore.model.map.MapConfig;
import de.terrestris.shoguncore.model.map.MapControl;
import de.terrestris.shoguncore.model.module.Module;
import de.terrestris.shoguncore.model.security.PermissionCollection;
import de.terrestris.shoguncore.model.token.Token;
import de.terrestris.shoguncore.security.access.entity.AlwaysAllowReadPermissionEvaluator;
import de.terrestris.shoguncore.security.access.entity.PermissionCollectionPermissionEvaluator;
import de.terrestris.shoguncore.security.access.entity.PersistentObjectPermissionEvaluator;
import de.terrestris.shoguncore.security.access.entity.UserGroupPermissionEvaluator;
import de.terrestris.shoguncore.security.access.entity.UserPermissionEvaluator;

public class EntityPermissionEvaluatorFactory<E extends PersistentObject> {
    public PersistentObjectPermissionEvaluator<E> getEntityPermissionEvaluator(Class<E> entityClass) {
        if (PermissionCollection.class.isAssignableFrom(entityClass)) {
            return new PermissionCollectionPermissionEvaluator();
        }
        if (User.class.isAssignableFrom(entityClass)) {
            return new UserPermissionEvaluator();
        }
        if (UserGroup.class.isAssignableFrom(entityClass)) {
            return new UserGroupPermissionEvaluator();
        }
        if (Extent.class.isAssignableFrom(entityClass) || InterceptorRule.class.isAssignableFrom(entityClass) || LayerAppearance.class.isAssignableFrom(entityClass) || LayerDataSource.class.isAssignableFrom(entityClass) || Layout.class.isAssignableFrom(entityClass) || MapConfig.class.isAssignableFrom(entityClass) || MapControl.class.isAssignableFrom(entityClass) || Module.class.isAssignableFrom(entityClass) || Role.class.isAssignableFrom(entityClass) || TileGrid.class.isAssignableFrom(entityClass) || Token.class.isAssignableFrom(entityClass)) {
            return new AlwaysAllowReadPermissionEvaluator();
        }
        return new PersistentObjectPermissionEvaluator<E>(entityClass);
    }
}

