/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shoguncore.service;

import de.terrestris.shoguncore.dao.GenericHibernateDao;
import de.terrestris.shoguncore.dao.PermissionCollectionDao;
import de.terrestris.shoguncore.model.PersistentObject;
import de.terrestris.shoguncore.model.User;
import de.terrestris.shoguncore.model.UserGroup;
import de.terrestris.shoguncore.model.security.Permission;
import de.terrestris.shoguncore.model.security.PermissionCollection;
import de.terrestris.shoguncore.service.AbstractCrudService;
import de.terrestris.shoguncore.service.PermissionCollectionService;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="permissionAwareCrudService")
public class PermissionAwareCrudService<E extends PersistentObject, D extends GenericHibernateDao<E, Integer>>
extends AbstractCrudService<E, D> {
    @Autowired
    @Qualifier(value="permissionCollectionService")
    protected PermissionCollectionService<PermissionCollection, PermissionCollectionDao<PermissionCollection>> permissionCollectionService;

    public PermissionAwareCrudService() {
        this(PersistentObject.class);
    }

    protected PermissionAwareCrudService(Class<E> entityClass) {
        super(entityClass);
    }

    @Override
    @Autowired
    @Qualifier(value="genericDao")
    public void setDao(D dao) {
        this.dao = dao;
    }

    public void addAndSaveUserPermissions(E entity, User user, Permission ... permissions) {
        if (entity == null) {
            this.LOG.error("Could not add permissions: The passed entity is NULL.");
            return;
        }
        HashSet<Permission> permissionsSet = new HashSet<Permission>(Arrays.asList(permissions));
        if (permissionsSet == null || permissionsSet.isEmpty()) {
            this.LOG.error("Could not add permissions: No permissions have been passed.");
            return;
        }
        PermissionCollection userPermissionCollection = ((PersistentObject)entity).getUserPermissions().get(user);
        boolean persistPermissionCollection = false;
        boolean persistEntity = false;
        if (userPermissionCollection == null) {
            userPermissionCollection = new PermissionCollection(permissionsSet);
            ((PersistentObject)entity).getUserPermissions().put(user, userPermissionCollection);
            this.LOG.debug("Attached a new permission collection for a user: " + permissionsSet);
            persistPermissionCollection = true;
            persistEntity = true;
        } else {
            Set<Permission> userPermissions = userPermissionCollection.getPermissions();
            int originalNrOfPermissions = userPermissions.size();
            userPermissions.addAll(permissionsSet);
            int newNrOfPermissions = userPermissions.size();
            if (newNrOfPermissions > originalNrOfPermissions) {
                persistPermissionCollection = true;
                this.LOG.debug("Added the following permissions to an existing permission collection: " + permissionsSet);
            }
        }
        if (persistPermissionCollection) {
            this.permissionCollectionService.saveOrUpdate(userPermissionCollection);
            this.LOG.debug("Persisted a permission collection");
            if (persistEntity) {
                this.saveOrUpdate(entity);
                this.LOG.debug("Persisted the entity with a new permission collection.");
            }
        }
    }

    public void removeAndSaveUserPermissions(E entity, User user, Permission ... permissions) {
        if (entity == null) {
            this.LOG.error("Could not remove permissions: The passed entity is NULL.");
            return;
        }
        HashSet<Permission> permissionsSet = new HashSet<Permission>(Arrays.asList(permissions));
        if (permissionsSet == null || permissionsSet.isEmpty()) {
            this.LOG.error("Could not remove permissions: No permissions have been passed.");
            return;
        }
        PermissionCollection userPermissionCollection = ((PersistentObject)entity).getUserPermissions().get(user);
        if (userPermissionCollection == null) {
            this.LOG.error("Could not remove permissions as there is no attached permission collection.");
            return;
        }
        Set<Permission> userPermissions = userPermissionCollection.getPermissions();
        int originalNrOfPermissions = userPermissions.size();
        userPermissions.removeAll(permissionsSet);
        int newNrOfPermissions = userPermissions.size();
        if (newNrOfPermissions == 0) {
            this.LOG.debug("The permission collection is empty and will thereby be deleted now.");
            ((PersistentObject)entity).getUserPermissions().remove(user);
            this.saveOrUpdate(entity);
            this.permissionCollectionService.delete(userPermissionCollection);
            return;
        }
        if (newNrOfPermissions < originalNrOfPermissions) {
            this.LOG.debug("Removed the following permissions from an existing permission collection: " + permissionsSet);
            this.permissionCollectionService.saveOrUpdate(userPermissionCollection);
            this.LOG.debug("Persisted a permission collection");
        }
    }

    public void addAndSaveGroupPermissions(E entity, UserGroup userGroup, Permission ... permissions) {
        if (entity == null) {
            this.LOG.error("Could not add permissions: The passed entity is NULL.");
            return;
        }
        HashSet<Permission> permissionsSet = new HashSet<Permission>(Arrays.asList(permissions));
        if (permissionsSet == null || permissionsSet.isEmpty()) {
            this.LOG.error("Could not add permissions: No permissions have been passed.");
            return;
        }
        PermissionCollection groupPermissionCollection = ((PersistentObject)entity).getGroupPermissions().get(userGroup);
        boolean persistPermissionCollection = false;
        boolean persistEntity = false;
        if (groupPermissionCollection == null) {
            groupPermissionCollection = new PermissionCollection(permissionsSet);
            ((PersistentObject)entity).getGroupPermissions().put(userGroup, groupPermissionCollection);
            this.LOG.debug("Attached a new permission collection for a group: " + permissionsSet);
            persistPermissionCollection = true;
            persistEntity = true;
        } else {
            Set<Permission> groupPermissions = groupPermissionCollection.getPermissions();
            int originalNrOfPermissions = groupPermissions.size();
            groupPermissions.addAll(permissionsSet);
            int newNrOfPermissions = groupPermissions.size();
            if (newNrOfPermissions > originalNrOfPermissions) {
                persistPermissionCollection = true;
                this.LOG.debug("Added the following permissions to an existing permission collection: " + permissionsSet);
            }
        }
        if (persistPermissionCollection) {
            this.permissionCollectionService.saveOrUpdate(groupPermissionCollection);
            this.LOG.debug("Persisted a permission collection");
            if (persistEntity) {
                this.saveOrUpdate(entity);
                this.LOG.debug("Persisted the entity with a new permission collection.");
            }
        }
    }

    public void removeAndSaveGroupPermissions(E entity, UserGroup userGroup, Permission ... permissions) {
        if (entity == null) {
            this.LOG.error("Could not remove permissions: The passed entity is NULL.");
            return;
        }
        HashSet<Permission> permissionsSet = new HashSet<Permission>(Arrays.asList(permissions));
        if (permissionsSet == null || permissionsSet.isEmpty()) {
            this.LOG.error("Could not remove permissions: No permissions have been passed.");
            return;
        }
        PermissionCollection groupPermissionCollection = ((PersistentObject)entity).getGroupPermissions().get(userGroup);
        if (groupPermissionCollection == null) {
            this.LOG.error("Could not remove permissions as there is no attached permission collection.");
            return;
        }
        Set<Permission> groupPermissions = groupPermissionCollection.getPermissions();
        int originalNrOfPermissions = groupPermissions.size();
        groupPermissions.removeAll(permissionsSet);
        int newNrOfPermissions = groupPermissions.size();
        if (newNrOfPermissions == 0) {
            ((PersistentObject)entity).getGroupPermissions().remove(userGroup);
            this.saveOrUpdate(entity);
            this.LOG.debug("The permission collection is empty and will thereby be deleted now.");
            this.permissionCollectionService.delete(groupPermissionCollection);
            return;
        }
        if (newNrOfPermissions < originalNrOfPermissions) {
            this.LOG.debug("Removed the following permissions from an existing permission collection: " + permissionsSet);
            this.permissionCollectionService.saveOrUpdate(groupPermissionCollection);
            this.LOG.debug("Persisted a permission collection");
        }
    }

    @PreAuthorize(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(#user, 'READ')")
    @Transactional(readOnly=true)
    public Map<PersistentObject, PermissionCollection> findAllUserPermissionsOfUser(User user) {
        return this.dao.findAllUserPermissionsOfUser(user);
    }

    @PreAuthorize(value="hasRole(@configHolder.getSuperAdminRoleName()) or hasPermission(#userGroup, 'READ')")
    @Transactional(readOnly=true)
    public Map<PersistentObject, PermissionCollection> findAllUserGroupPermissionsOfUserGroup(UserGroup userGroup) {
        return this.dao.findAllUserGroupPermissionsOfUserGroup(userGroup);
    }

    public PermissionCollectionService<PermissionCollection, PermissionCollectionDao<PermissionCollection>> getPermissionCollectionService() {
        return this.permissionCollectionService;
    }

    public void setPermissionCollectionService(PermissionCollectionService<PermissionCollection, PermissionCollectionDao<PermissionCollection>> permissionCollectionService) {
        this.permissionCollectionService = permissionCollectionService;
    }
}

